% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol_oversampling.R
\name{vol.oversampling}
\alias{vol.oversampling}
\title{Oversampling a volume}
\usage{
vol.oversampling(
  vol,
  fact.ijk = 2,
  alias = "",
  interpolate = TRUE,
  description = NULL
)
}
\arguments{
\item{vol}{"volume" class object.}

\item{fact.ijk}{Strictly positive integer, or a vector of 3 strictly positive integers.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{interpolate}{Boolean, default to \code{TRUE}. If \code{interpolate = TRUE}, a
trilinear interpolation of the value of the voxels, relative to the values of
adjacent voxels, is performed.}

\item{description}{Character string, describing the the created object.
If \code{description = NULL}, it will be \code{paste ("oversampling" ,vol$description)}.}
}
\value{
Returns a "volume" class object, in which 3D volume grid is
oversampled: the voxel size is divided by \code{fact.ijk}.
}
\description{
The \code{vol.oversampling} function oversamples the grid of a "volume" class
object.
}
\examples{
vol <- vol.create(n.ijk = c(10,10,1),dxyz = c(2,2,2), ref.pseudo = "ref1", 
                  modality ="test", pt000 = c(0,0,0))
vol$vol3D.data[] <- array(1:prod(vol$n.ijk), dim = vol$n.ijk)
vol$max.pixel <- prod(vol$n.ijk)
vol$min.pixel <- 1
mid <- as.numeric (apply (get.extreme.pt (vol), 1, mean))
 
vol_os <- vol.oversampling (vol, fact.ijk= c(2,2,1))
mid_os <- as.numeric (apply (get.extreme.pt (vol_os), 1, mean))

display.plane(vol,interpolate = FALSE, view.coord = mid[3], 
              abs.rng = c(-5,25), ord.rng = c(-5,25), bg="green")
points (mid[1], mid[2], pch=16, col="red")
display.plane(vol_os,interpolate = FALSE, view.coord = mid_os[3], 
              abs.rng = c(-5,25), ord.rng = c(-5,25), bg="green")
points (mid_os[1], mid_os[2], pch=16, col="red")
}
\seealso{
\link[espadon]{vol.subsampling}.
}
