% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{beta_priors}
\alias{beta_priors}
\title{Set prior specifications for the slope parameters}
\usage{
beta_priors(
  k,
  beta_mean_prior = matrix(0, k, 1),
  beta_var_prior = diag(k) * 100
)
}
\arguments{
\item{k}{The total number of slope parameters in the model.}

\item{beta_mean_prior}{numeric \eqn{k} by \eqn{1} matrix of prior means \eqn{\underline{\mu}_\beta}.}

\item{beta_var_prior}{A \eqn{k} by \eqn{k} matrix of prior variances \eqn{\underline{V}_\beta}. Defaults to a
diagonal matrix with \code{100} on the main diagonal.}
}
\value{
A list with the prior mean vector (\code{beta_mean_prior}), the prior variance matrix
(\code{beta_var_prior}) and the inverse of the prior variance matrix (\code{beta_var_prior_inv}).
}
\description{
This function allows the user to specify custom values for Gaussian priors on the slope parameters.
}
\details{
For the slope parameters \eqn{\beta} the package uses common Normal
prior specifications. Specifically,  \eqn{p(\beta)\sim\mathcal{N}(\underline{\mu}_\beta,\underline{V}_\beta)}.

This function allows the user to specify custom values for the prior hyperparameters \eqn{\underline{\mu}_\beta}
and \eqn{\underline{V}_\beta}. The default values correspond to weakly informative Gaussian priors with mean
zero and a diagonal prior variance-covariance matrix with \eqn{100} on the main diagonal.
}
