
<!-- README.md is generated from README.Rmd. Please edit that file -->

<!-- CRAN stats for the Readme file -->

[![CRAN
Status](http://www.r-pkg.org/badges/version/ethnobotanyR?color=yellow)](https://cran.r-project.org/package=ethnobotanyR)
[![](http://cranlogs.r-pkg.org/badges/grand-total/ethnobotanyR?color=orange)](https://cran.r-project.org/package=ethnobotanyR)
[![](http://cranlogs.r-pkg.org/badges/ethnobotanyR?color=blue)](https://cran.r-project.org/package=ethnobotanyR)
[![](http://cranlogs.r-pkg.org/badges/last-week/ethnobotanyR?color=green)](https://cran.r-project.org/package=ethnobotanyR)

# ethnobotanyR

The goal of ethnobotanyR is to provide an easy-to-use platform for
ethnobotanists to calculate quantitative ethnobotany indices. It closely
follows Tardio and Pardo-de-Santayana (2008) and Whitney et al. (2018).
Users are highly encouraged to read these and the the theory papers of
Albuquerque et al. (2019) and Gaoue et al. (2017). Both papers offer
helpful guidance to understanding theoretical approaches in ethnobotany
and developing meaningful hypotheses.

<img src="vignettes/ethnobotanyR.png" width="20%" />

## Installation

Install the released version of ethnobotanyR from
[CRAN](https://CRAN.R-project.org) with
`install.packages("ethnobotanyR")`.

Install the working version of ethnobotanyR from
[GitHub](https://github.com) with
`devtools::install_github(“CWWhitney/ethnobotanyR”)`.

Read more in [Quantitative ethnobotany analysis with
ethnobotanyR](http://htmlpreview.github.io/?https://github.com/CWWhitney/ethnobotanyR/blob/master/vignettes/ethnobotanyr_vignette.html)

## References

Albuquerque, Ulysses Paulino, Patricia Muniz de Medeiros, Washington
Soares Ferreira Junior, Taline Cristina da Silva, Rafael Ricardo
Vasconcelos da Silva, and Thiago Goncalves-Souza. 2019.
Social-Ecological Theory of Maximization: Basic Concepts and Two Initial
Models. Biological Theory. doi.org/10.1007/s13752-019-00316-8.

Gaoue, Orou G., Michael A. Coe, Matthew Bond, Georgia Hart, Barnabas C.
Seyler, and Heather McMillen. 2017. Theories and Major Hypotheses in
Ethnobotany. Economic Botany 71: 269–287.
doi.org/10.1007/s12231-017-9389-8.

Tardio, J., and M. Pardo-de-Santayana, 2008. Cultural Importance
Indices: A Comparative Analysis Based on the Useful Wild Plants of
Southern Cantabria (Northern Spain) 1. Economic Botany, 62(1), 24-39.
doi.org/10.1007/s12231-007-9004-5.

Whitney, C. W., Bahati, J., and Gebauer, J. (2018), Ethnobotany and
agrobiodiversity; valuation of plants in the homegardens of southwestern
Uganda. Ethnobiology Letters, 9(2), 90-100.
doi.org/10.14237/ebl.9.2.2018.503
