% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethnoChord.R
\name{ethnoChord}
\alias{ethnoChord}
\title{Chord diagram of ethnobotany uses and species}
\usage{
ethnoChord(data, by)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}

\item{by}{indicates the variable that should be mapped to the bottom of the chord diagram. This automatically defaults to the column referring to the species (by = "sp_name")}
}
\value{
Chord diagram figure for each use by 'informant' (top half) related to each 'sp_name' (bottom half) in the data set. 
To change variable names try using the dplyr rename function.
}
\description{
Creates a simple chord diagram of species and uses for ethnobotany studies. For more on the circlize package see Zuguang Gu's 'Circular Visualization in R' \url{https://jokergoo.github.io/circlize_book/book/}
}
\section{Warning}{


Identification for informants and species must be listed by the names 'informant' and 'sp_name' respectively in the data set.
The rest of the columns represent the identified ethnobotany use categories. These data should be populated with counts of uses per person (should be 0 or 1 values).
}

\examples{

#Use built-in ethnobotany data example
ethnoChord(ethnobotanydata, by = "informant")

#Generate random dataset of three informants uses for four species

eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant <- sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name <- sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)

ethnoChord(eb_data, by = "informant")

}
\references{
Gu, Zuguang, Lei Gu, Roland Eils, Matthias Schlesner, and Benedikt Brors. “Circlize Implements and Enhances Circular Visualization in R.” Bioinformatics, 2014, 393.

Whitney, C. W., Bahati, J., and Gebauer, J. (2018), Ethnobotany and agrobiodiversity; valuation of plants in the homegardens of southwestern Uganda. Ethnobiology Letters, 9(2), 90-100. \doi{10.14237/ebl.9.2.2018.503}
}
\keyword{arith}
\keyword{graphs}
\keyword{logic}
\keyword{math}
\keyword{methods}
\keyword{misc}
\keyword{survey}
