% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ethno_alluvial.R
\name{ethno_alluvial}
\alias{ethno_alluvial}
\title{Alluvial plot of ethnobotany uses and species}
\usage{
ethno_alluvial(data, alpha = 0)
}
\arguments{
\item{data}{is an ethnobotany data set with column 1 'informant' and 2 'sp_name' as row identifiers of informants and of species names respectively.
The rest of the columns are the identified ethnobotany use categories. The data should be populated with counts of uses per person (should be 0 or 1 values).}

\item{alpha}{is a number between 0 and 1 for the level of transparency behind the labels on the strata (default is 0).}
}
\value{
Alluvial diagram showing all use reports for each use (center) related to each species (left) and informant (right) in the data set.
}
\description{
Creates a simple alluvial plot of species and uses for ethnobotany studies.
}
\section{Warning}{


Identification for informants and species must be listed by the names 'informant' and 'sp_name' respectively in the data set.
The rest of the columns represent the identified ethnobotany use categories. These data should be populated with counts of uses per person (should be 0 or 1 values).
}

\examples{

#Use built-in ethnobotany data example
ethno_alluvial(ethnobotanydata)

#Generate random dataset of three informants uses for four species

eb_data <- data.frame(replicate(10,sample(0:1,20,rep=TRUE)))
names(eb_data) <- gsub(x = names(eb_data), pattern = "X", replacement = "Use_")  
eb_data$informant <- sample(c('User_1', 'User_2', 'User_3'), 20, replace=TRUE)
eb_data$sp_name <- sample(c('sp_1', 'sp_2', 'sp_3', 'sp_4'), 20, replace=TRUE)

# Default plot ####

ethno_alluvial(eb_data)

}
\references{
Mon, Aye Mya, Yinxian Shi, Xuefei Yang, Pyae Phyo Hein, Thaung Naing Oo, Cory Whitney, and Yongping Yang. “The Uses of Fig (Ficus) by Five Ethnic Minority Communities in Southern Shan State, Myanmar.” Journal of Ethnobiology and Ethnomedicine 16, no. 5 (2020). \doi{10.1186/s13002-020-00406-z}
}
\keyword{arith}
\keyword{graphs}
\keyword{logic}
\keyword{math}
\keyword{methods}
\keyword{misc}
\keyword{survey}
