% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inventory_cmip5.R
\name{check_inventory_cmip5}
\alias{check_inventory_cmip5}
\title{Perform some checks on the inventory of CMIP5 files}
\usage{
check_inventory_cmip5(data_inventory, check_hist = FALSE)
}
\arguments{
\item{data_inventory}{A data.table as resulting from
\code{\link{get_inventory}}.}

\item{check_hist}{Boolean, if \code{TRUE}, tests that each rcp* has a corresponding historical run.}
}
\value{
An object of class "eurocordexr_inv_check_cmip5" (an overloaded list) with results
from the checks. Has a special print method, which shows a verbose summary of the results.
}
\description{
Some simple checks for multiple time frequencies, ensembles, and completeness
of simulation periods. These checks are meant as guides only, since one might
not wish multiple elements of the above for climate model ensemble
assessments.
}
\details{
The checks are \itemize{
\item for multiple time frequency (day, month, ...)
\item for multiple ensembles (r1i1p1, r2i1p1, ...)
\item for complete periods of simulations: here complete means at least
1860-2005 for historical and 2006-2099 for rcp*
\item that each rcp* has a corresponding historical run (optional, off by
default; otherwise problematic with merged hist and rcp runs)
}
}
\examples{
# some empty example files
fn_zip <- system.file("extdata", "inv-test-files-cmip5.zip", package = "eurocordexr")
tmpdir <- tempdir()
unzip(fn_zip, exdir = tmpdir)

dat_inv <- get_inventory_cmip5(fs::path(tmpdir, "testdata-cmip5"))
check_inventory_cmip5(dat_inv)

}
