% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{MoMGPD}
\alias{MoMGPD}
\title{Method of moments (MoM) on a one or multiple exceedance timeseries for the
latent trawl model using marginal GPD properties and probability of exceedance.}
\usage{
MoMGPD(values_array)
}
\arguments{
\item{values_array}{Matrix of exceedance timeseries}
}
\value{
Parameters given by a second-order method of moments as well as standard deviation across
timeseries for each individual parameter.
}
\description{
Method of moments (MoM) on a one or multiple exceedance timeseries for the
latent trawl model using marginal GPD properties and probability of exceedance.
}
\examples{
exceed1 <- c(0.1, 0, 0.2, 0, 0, 0, 0.6, 1.5)
exceed2 <- c(0, 0.3, 5.2, 0, 0, 3.0, 0, 2.2)
val_array <- cbind(exceed1, exceed2)
MoMGPD(val_array)

}
