% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_latent_trawl.R
\name{PairwiseOneZero}
\alias{PairwiseOneZero}
\title{Computes term in latent trawl pairwise likelihood with \code{(x,0)} where \code{x} positive
with exponential trawl function.}
\usage{
PairwiseOneZero(x1, alpha, beta, kappa, B1, B2, B3, transformation = F,
  n.moments = 4)
}
\arguments{
\item{x1}{Positive value corresponding to \code{t1}.}

\item{alpha}{Shape parameter. Should be positive.}

\item{beta}{Latent Gamma scale parameter. Should be positive.}

\item{kappa}{Exceedance probability parameter. Should be positive.}

\item{B1}{Difference area between \code{t1} and \code{t2} (in this order).}

\item{B2}{intersection area between \code{t1} and \code{t2} (in this order).}

\item{B3}{Difference area between \code{t2} and \code{t1} (in this order).}

\item{transformation}{Boolean to use the Marginal Transform (MT) method.}

\item{n.moments}{Number of moments achieved by transformed GPD marginals, if used.}
}
\value{
Second term in latent trawl pairwise likelihood with \code{(x,0)} where \code{x} positive
with exponential trawl function.
}
\description{
Computes term in latent trawl pairwise likelihood with \code{(x,0)} where \code{x} positive
with exponential trawl function.
}
\examples{
PairwiseOneZero(x1=0.5, alpha=0.3, beta=2, kappa=3, B1=0.3, B2=0.7, B3=0.3)

}
