% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_dist.R
\name{knn_dist}
\alias{knn_dist}
\title{K nearest neighbors in a dissimilarity matrix}
\usage{
knn_dist(D, K)
}
\arguments{
\item{D}{Dissimilarity matrix of size (n,n), where n is the number of objects.}

\item{K}{Number of neighbors}
}
\value{
A list with two components:
\describe{
  \item{nn.dist}{An (n,K) matrix for the nearest neighbor dissimilarities.}
  \item{nn.index}{An (n,K) matrix for the nearest neighbor indices.}
}
}
\description{
\code{knn_dist} searches for nearest neighbors in a dissimilarity matrix matrix.
}
\details{
This function is called by \code{\link{EkNNclus}} if argument x is not supplied.
It is not optimized and cannot be used for very large D. If an attribute matrix
x is supplied and D is the matrix of Euclidean distances, it is preferable to use
function \code{\link[FNN]{get.knn}} from package \code{FNN}.
}
\examples{
data(butterfly)
n <- nrow(butterfly)
D<-as.matrix(dist(butterfly))
knn<-knn_dist(D,K=2)
knn$nn.dist
knn$nn.index
}
\author{
Thierry Denoeux.
}
\seealso{
\code{\link[FNN]{get.knn}}, \code{\link{EkNNclus}}
}

