% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDropout.R
\name{fitDropout}
\alias{fitDropout}
\title{Fit time-to-dropout model}
\usage{
fitDropout(
  df,
  dropout_model = "exponential",
  piecewiseDropoutTime = 0,
  showplot = TRUE,
  by_treatment = FALSE
)
}
\arguments{
\item{df}{The subject-level dropout data, including \code{time} and
\code{dropout}. The data should also include \code{treatment}
coded as 1, 2, and so on, for fitting the dropout model by treatment.}

\item{dropout_model}{The dropout model used to analyze the dropout data
which can be set to one of the following options: "exponential",
"Weibull", "log-normal", or "piecewise exponential". By default,
it is set to "exponential".}

\item{piecewiseDropoutTime}{A vector that specifies the time
intervals for the piecewise exponential dropout distribution.
Must start with 0, e.g., c(0, 60) breaks the time axis into 2
event intervals: [0, 60) and [60, Inf). By default, it is set to 0.}

\item{showplot}{A Boolean variable to control whether or not to
show the fitted time-to-dropout survival curve. By default, it is
set to \code{TRUE}.}

\item{by_treatment}{A Boolean variable to control whether or not to
fit the time-to-dropout data by treatment group. By default,
it is set to \code{FALSE}.}
}
\value{
A list of results from the model fit including key information
such as the dropout model, \code{model}, the estimated model parameters,
\code{theta}, the covariance matrix, \code{vtheta}, as well as the
Bayesian Information Criterion, \code{bic}.

If the piecewise exponential model is used, the location
of knots used in the model, \code{piecewiseDropoutTime}, will
be included in the list of results.

When fitting the dropout model by treatment, the outcome is presented
as a list of lists, where each list element corresponds to a
specific treatment group.

The fitted time-to-dropout survival curve is also returned.
}
\description{
Fits a specified time-to-dropout model to the dropout data.
}
\examples{

dropout_fit <- fitDropout(df = interimData2, dropout_model = "exponential")

}
