% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbckdengpdcon.r
\name{bckdengpdcon}
\alias{bckdengpdcon}
\alias{dbckdengpdcon}
\alias{pbckdengpdcon}
\alias{qbckdengpdcon}
\alias{rbckdengpdcon}
\alias{dbckdengpdcon}
\alias{bckdengpdcon}
\alias{pbckdengpdcon}
\alias{qbckdengpdcon}
\alias{rbckdengpdcon}
\alias{pbckdengpdcon}
\alias{bckdengpdcon}
\alias{dbckdengpdcon}
\alias{qbckdengpdcon}
\alias{rbckdengpdcon}
\alias{qbckdengpdcon}
\alias{bckdengpdcon}
\alias{dbckdengpdcon}
\alias{pbckdengpdcon}
\alias{rbckdengpdcon}
\alias{rbckdengpdcon}
\alias{bckdengpdcon}
\alias{dbckdengpdcon}
\alias{pbckdengpdcon}
\alias{qbckdengpdcon}
\title{Boundary Corrected Kernel Density Estimate and GPD Tail Extreme Value Mixture Model
 With Single Continuity Constraint}
\usage{
dbckdengpdcon(x, kerncentres, lambda = NULL,
  u = as.vector(quantile(kerncentres, 0.9)), xi = 0, phiu = TRUE,
  bw = NULL, kernel = "gaussian", bcmethod = "simple", proper = TRUE,
  nn = "jf96", offset = NULL, xmax = NULL, log = FALSE)

pbckdengpdcon(q, kerncentres, lambda = NULL,
  u = as.vector(quantile(kerncentres, 0.9)), xi = 0, phiu = TRUE,
  bw = NULL, kernel = "gaussian", bcmethod = "simple", proper = TRUE,
  nn = "jf96", offset = NULL, xmax = NULL, lower.tail = TRUE)

qbckdengpdcon(p, kerncentres, lambda = NULL,
  u = as.vector(quantile(kerncentres, 0.9)), xi = 0, phiu = TRUE,
  bw = NULL, kernel = "gaussian", bcmethod = "simple", proper = TRUE,
  nn = "jf96", offset = NULL, xmax = NULL, lower.tail = TRUE)

rbckdengpdcon(n = 1, kerncentres, lambda = NULL,
  u = as.vector(quantile(kerncentres, 0.9)), xi = 0, phiu = TRUE,
  bw = NULL, kernel = "gaussian", bcmethod = "simple", proper = TRUE,
  nn = "jf96", offset = NULL, xmax = NULL)
}
\arguments{
\item{x}{quantiles}

\item{kerncentres}{kernel centres (typically sample data vector or scalar)}

\item{lambda}{bandwidth for kernel (as half-width of kernel) or \code{NULL}}

\item{u}{threshold}

\item{xi}{shape parameter}

\item{phiu}{probability of being above threshold \eqn{[0, 1]} or \code{TRUE}}

\item{bw}{bandwidth for kernel (as standard deviations of kernel) or \code{NULL}}

\item{kernel}{kernel name (\code{default = "gaussian"})}

\item{bcmethod}{boundary correction method}

\item{proper}{logical, whether density is renormalised to integrate to unity (where needed)}

\item{nn}{non-negativity correction method (simple boundary correction only)}

\item{offset}{offset added to kernel centres (logtrans only) or \code{NULL}}

\item{xmax}{upper bound on support (copula and beta kernels only) or \code{NULL}}

\item{log}{logical, if TRUE then log density}

\item{q}{quantiles}

\item{lower.tail}{logical, if FALSE then upper tail probabilities}

\item{p}{cumulative probabilities}

\item{n}{sample size (positive integer)}
}
\value{
\code{\link[evmix:bckdengpdcon]{dbckdengpdcon}} gives the density, 
\code{\link[evmix:bckdengpdcon]{pbckdengpdcon}} gives the cumulative distribution function,
\code{\link[evmix:bckdengpdcon]{qbckdengpdcon}} gives the quantile function and 
\code{\link[evmix:bckdengpdcon]{rbckdengpdcon}} gives a random sample.
}
\description{
Density, cumulative distribution function, quantile function and
  random number generation for the extreme value mixture model with 
  boundary corrected kernel density estimate for bulk
  distribution upto the threshold and conditional GPD above threshold with continuity at
  threshold. The parameters are the bandwidth \code{lambda}, threshold \code{u}
  GPD shape \code{xi} and tail fraction \code{phiu}.
}
\details{
Extreme value mixture model combining boundary corrected kernel density (BCKDE)
estimate for the bulk below the threshold and GPD for upper tail with continuity at
threshold. The user chooses from a wide range of boundary correction methods
designed to cope with a lower bound at zero and potentially also both upper and
lower bounds.

Some boundary correction methods require a secondary correction for
negative density estimates of which two methods are implemented. Further, some
methods don't necessarily give a density which integrates to one, so an option
is provided to renormalise to be proper.

It assumes there is a lower bound at zero, so prior transformation of data is
required for a alternative lower bound (possibly including negation to allow
for an upper bound).

The user can pre-specify \code{phiu} permitting a parameterised value for the
tail fraction \eqn{\phi_u}. Alternatively, when \code{phiu=TRUE} the tail fraction
is estimated as the tail fraction from the BCKDE bulk model.

The alternate bandwidth definitions are discussed in the
\code{\link[evmix:kernels]{kernels}}, with the \code{lambda} as the default.
The \code{bw} specification is the same as used in the
\code{\link[stats:density]{density}} function.

The possible kernels are also defined in \code{\link[evmix:kernels]{kernels}}
with the \code{"gaussian"} as the default choice.

The cumulative distribution function with tail fraction \eqn{\phi_u} defined by the
upper tail fraction of the BCKDE (\code{phiu=TRUE}), upto the threshold
\eqn{x \le u}, given by:
\deqn{F(x) = H(x)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = H(u) + [1 - H(u)] G(x)}
where \eqn{H(x)} and \eqn{G(X)} are the BCKDE and conditional GPD
cumulative distribution functions respectively.

The cumulative distribution function for pre-specified \eqn{\phi_u}, upto the
threshold \eqn{x \le u}, is given by:
\deqn{F(x) = (1 - \phi_u) H(x)/H(u)}
and above the threshold \eqn{x > u}:
\deqn{F(x) = \phi_u + [1 - \phi_u] G(x)}
Notice that these definitions are equivalent when \eqn{\phi_u = 1 - H(u)}.

The continuity constraint means that \eqn{(1 - \phi_u) h(u)/H(u) = \phi_u g(u)}
where \eqn{h(x)} and \eqn{g(x)} are the BCKDE and conditional GPD
density functions respectively. The resulting GPD scale parameter is then:
\deqn{\sigma_u = \phi_u H(u) / [1 - \phi_u] h(u)}.
In the special case of where the tail fraction is defined by the bulk model this reduces to
\deqn{\sigma_u = [1 - H(u)] / h(u)}.

Unlike the standard KDE, there is no general rule-of-thumb bandwidth for all the
BCKDE, with only certain methods having a guideline in the literature, so none
have been implemented. Hence, a bandwidth must always be specified and you should
consider using \code{\link[evmix:fbckdengpdcon]{fbckdengpdcon}} of 
\code{\link[evmix:fbckden]{fbckden}} function for cross-validation
MLE for bandwidth.

See \code{\link[evmix:gpd]{gpd}} for details of GPD upper tail component and 
\code{\link[evmix:bckden]{dbckden}} for details of BCKDE bulk component.
}
\note{
Unlike most of the other extreme value mixture model functions the 
\code{\link[evmix:bckdengpdcon]{bckdengpdcon}} functions have not been vectorised as
this is not appropriate. The main inputs (\code{x}, \code{p} or \code{q})
must be either a scalar or a vector, which also define the output length.
The \code{kerncentres} can also be a scalar or vector.

The kernel centres \code{kerncentres} can either be a single datapoint or a vector
of data. The kernel centres (\code{kerncentres}) and locations to evaluate density (\code{x})
and cumulative distribution function (\code{q}) would usually be different.

Default values are provided for all inputs, except for the fundamentals 
\code{kerncentres}, \code{x}, \code{q} and \code{p}. The default sample size for 
\code{\link[evmix:bckdengpdcon]{rbckdengpdcon}} is 1.

The \code{xmax} option is only relevant for the beta and copula methods, so a
warning is produced if this is not \code{NULL} for in other methods.
The \code{offset} option is only relevant for the \code{"logtrans"} method, so a
warning is produced if this is not \code{NULL} for in other methods.

Missing (\code{NA}) and Not-a-Number (\code{NaN}) values in \code{x},
\code{p} and \code{q} are passed through as is and infinite values are set to
\code{NA}. None of these are not permitted for the parameters or kernel centres.

Error checking of the inputs (e.g. invalid probabilities) is carried out and
will either stop or give warning message as appropriate.
}
\section{Boundary Correction Methods}{


See \code{\link[evmix:bckden]{dbckden}} for details of BCKDE methods.
}

\section{Warning}{

The \code{"simple"}, \code{"renorm"}, \code{"beta1"}, \code{"beta2"}, \code{"gamma1"} 
and \code{"gamma2"} boundary correction methods may require renormalisation using
numerical integration which can be very slow. In particular, the numerical integration
is extremely slow for the \code{kernel="uniform"}, due to the adaptive quadrature in
the \code{\link[stats:integrate]{integrate}} function
being particularly slow for functions with step-like behaviour.
}

\section{Acknowledgments}{
 Based on code
by Anna MacDonald produced for MATLAB.
}

\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 2))

kerncentres=rgamma(500, shape = 1, scale = 2)
xx = seq(-0.1, 10, 0.01)
hist(kerncentres, breaks = 100, freq = FALSE)
lines(xx, dbckdengpdcon(xx, kerncentres, lambda = 0.5, bcmethod = "reflect"),
xlab = "x", ylab = "f(x)")
abline(v = quantile(kerncentres, 0.9))

plot(xx, pbckdengpdcon(xx, kerncentres, lambda = 0.5, bcmethod = "reflect"),
xlab = "x", ylab = "F(x)", type = "l")
lines(xx, pbckdengpdcon(xx, kerncentres, lambda = 0.5, xi = 0.3, bcmethod = "reflect"),
xlab = "x", ylab = "F(x)", col = "red")
lines(xx, pbckdengpdcon(xx, kerncentres, lambda = 0.5, xi = -0.3, bcmethod = "reflect"),
xlab = "x", ylab = "F(x)", col = "blue")
legend("topleft", paste("xi =",c(0, 0.3, -0.3)),
      col=c("black", "red", "blue"), lty = 1, cex = 0.5)

kerncentres = rweibull(1000, 2, 1)
x = rbckdengpdcon(1000, kerncentres, lambda = 0.1, phiu = TRUE, bcmethod = "reflect")
xx = seq(0.01, 3.5, 0.01)
hist(x, breaks = 100, freq = FALSE)         
lines(xx, dbckdengpdcon(xx, kerncentres, lambda = 0.1, phiu = TRUE, bcmethod = "reflect"),
xlab = "x", ylab = "f(x)")

lines(xx, dbckdengpdcon(xx, kerncentres, lambda = 0.1, xi=-0.2, phiu = 0.1, bcmethod = "reflect"),
xlab = "x", ylab = "f(x)", col = "red")
lines(xx, dbckdengpdcon(xx, kerncentres, lambda = 0.1, xi=0.2, phiu = 0.1, bcmethod = "reflect"),
xlab = "x", ylab = "f(x)", col = "blue")
legend("topleft", c("xi = 0", "xi = 0.2", "xi = -0.2"),
      col=c("black", "red", "blue"), lty = 1)
}

}
\references{
\url{http://en.wikipedia.org/wiki/Kernel_density_estimation}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Bowman, A.W. (1984). An alternative method of cross-validation for the smoothing of
density estimates. Biometrika 71(2), 353-360.

Duin, R.P.W. (1976). On the choice of smoothing parameters for Parzen estimators of
probability density functions. IEEE Transactions on Computers C25(11), 1175-1179.

MacDonald, A., Scarrott, C.J., Lee, D., Darlow, B., Reale, M. and Russell, G. (2011).
A flexible extreme value mixture model. Computational Statistics and Data Analysis
55(6), 2137-2157.

MacDonald, A., C. J. Scarrott, and D. S. Lee (2011). Boundary correction, consistency
and robustness of kernel densities using extreme value theory. Submitted.
Available from: \url{http://www.math.canterbury.ac.nz/~c.scarrott}.

Wand, M. and Jones, M.C. (1995). Kernel Smoothing. Chapman && Hall.
}
\seealso{
\code{\link[evmix:gpd]{gpd}}, \code{\link[evmix:kernels]{kernels}}, 
\code{\link[evmix:kfun]{kfun}},
\code{\link[stats:density]{density}}, \code{\link[stats:bandwidth]{bw.nrd0}}
and \code{\link[ks:kde]{dkde}} in \code{\link[ks:kde]{ks}} package.

Other kden kdengpd kdengpdcon bckden bckdengpd bckdengpdcon
         fkden fkdengpd fkdengpdcon fbckden fbckdengpd fbckdengpdcon: \code{\link{bckdengpd}},
  \code{\link{bckden}}, \code{\link{fbckden}},
  \code{\link{fkden}}, \code{\link{kdengpdcon}},
  \code{\link{kdengpd}}, \code{\link{kden}}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}.
}
