% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AncestralStates.R
\name{AncestralStates}
\alias{AncestralStates}
\title{Fast estimation of ML ancestral stated for multivariate continous traits}
\usage{
AncestralStates(tree, x, ...)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{x}{list of tip nodes data. Expects one vector for each terminal.}

\item{...}{aditional arguments for phytools::fastAnc}
}
\value{
list with calculated ancestral states, using labels or numbers from tree
}
\description{
This function is a wrapper for using phytools::fastAnc on multivariate data.
}
\note{
Each trait is estimated independently. Squared prcimony estimation can be made by setting tree brach lengths to 1.
}
\examples{
data(dentus)
data(dentus.tree)
mean.list <- dlply(dentus, .(species), numcolwise(mean))
names(mean.list) <- dentus.tree$tip.label
AncestralStates(dentus.tree, mean.list)
}

