% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DriftTest.R
\name{TreeDriftTest}
\alias{TreeDriftTest}
\title{Drift test along phylogeny}
\usage{
TreeDriftTest(tree, mean.list, cov.matrix.list, sample.sizes = NULL)
}
\arguments{
\item{tree}{phylogenetic tree}

\item{mean.list}{list of tip node means. Names must match tip node labels.}

\item{cov.matrix.list}{list of tip node covariance matrices. Names must match tip node labels.}

\item{sample.sizes}{vector of tip nodes sample sizes}
}
\value{
A list of regression drift tests performed in nodes with over 4 descendant tips.
}
\description{
Performs a regression drift test along a phylogeny using DriftTest function.
}
\examples{
library(ape)
data(bird.orders)

tree <- bird.orders
mean.list <- llply(tree$tip.label, function(x) rnorm(5))
names(mean.list) <- tree$tip.label
cov.matrix.list <- RandomMatrix(5, length(tree$tip.label))
names(cov.matrix.list) <- tree$tip.label
sample.sizes <- runif(length(tree$tip.label), 15, 20)

test.list <- TreeDriftTest(tree, mean.list, cov.matrix.list, sample.sizes)

#Ancestral node plot:
test.list[[length(test.list)]]$plot
}
\author{
Diogo Melo
}
\seealso{
DriftTest PlotTreeDriftTest
}

