% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparisonMap.R
\name{ComparisonMap}
\alias{ComparisonMap}
\title{Generic Comparison Map functions for creating parallel list methods
Internal functions for making eficient comparisons.}
\usage{
ComparisonMap(matrix.list, MatrixCompFunc, ..., repeat.vector = NULL,
  parallel = FALSE)
}
\arguments{
\item{matrix.list}{list of matrices being compared}

\item{MatrixCompFunc}{Function used to compare pair of matrices, must output a vector: comparisons and probabilities}

\item{...}{Aditional arguments to MatrixCompFunc}

\item{repeat.vector}{Vector of repeatabilities for correlation correction.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
Matrix of comparisons, matrix of probabilities.
}
\description{
Generic Comparison Map functions for creating parallel list methods
Internal functions for making eficient comparisons.
}
\seealso{
\code{\link{MantelCor}}, \code{\link{KrzCor}},\code{\link{RandomSkewers}}
}
\author{
Diogo Melo
}
