% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rarefaction.R
\name{RarefactionStat}
\alias{RarefactionStat}
\title{Non-Parametric rarefacted population samples and statistic comparison}
\usage{
RarefactionStat(ind.data, StatFunc, ComparisonFunc, ..., num.reps = 10,
  replace = FALSE, parallel = FALSE)
}
\arguments{
\item{ind.data}{Matrix of residuals or indiviual measurments}

\item{StatFunc}{Function for calculating the statistic}

\item{ComparisonFunc}{comparison function}

\item{...}{Aditional arguments passed to ComparisonFunc}

\item{num.reps}{number of populations sampled per sample size}

\item{replace}{If true, samples are taken with replacement}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns the mean value of comparisons from samples to original statistic, for all sample sizes.
}
\description{
Calculates the repeatability of a statistic of the data, such as
correlation or covariance matrix, via resampling with
varying sample sizes, from 2 to the size of the original data.
}
\details{
Samples of various sizes, without replacement, are taken from the full population, a statistic calculated and compared to the full population statistic.

A specialized ploting function displays the results in publication quality.

Bootstraping may be misleading with very small sample sizes. Use with caution.
}
\examples{
ind.data <- iris[1:50,1:4]

#Can be used to calculate any statistic via Rarefaction, not just comparisons
#Integration, for instanse:
results.R2 <- RarefactionStat(ind.data, cor, function(x, y) CalcR2(y), num.reps = 5)

#Easy access
library(reshape2)
melt(results.R2)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#results.R2 <- RarefactionStat(ind.data, cor, function(x, y) CalcR2(y), parallel = TRUE)

}
\seealso{
\code{\link{BootstrapRep}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{bootstap}
\keyword{rarefaction}
\keyword{repeatability}
