% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcRepeatability.R
\name{CalcRepeatability}
\alias{CalcRepeatability}
\title{Parametric per trait repeatabilities}
\usage{
CalcRepeatability(ID, ind.data)
}
\arguments{
\item{ID}{identity of individuals}

\item{ind.data}{individual measurements}
}
\value{
vector of repeatabilities
}
\description{
Estimates the variance in the sample not due to measurement error
}
\note{
Requires at least two observations per individual
}
\examples{
num.ind = length(iris[,1])
ID = rep(1:num.ind, 2)
ind.data = rbind(iris[,1:4], iris[,1:4]+array(rnorm(num.ind*4, 0, 0.1), dim(iris[,1:4])))
CalcRepeatability(ID, ind.data)
}
\references{
Lessels, C. M., and Boag, P. T. (1987).
   Unrepeatable repeatabilities: a common mistake.
   The Auk, 2(January), 116-121.
}
\author{
Guilherme Garcia
}
