% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch09LDLRA_GA.R
\name{StrLearningPBIL_LDLRA}
\alias{StrLearningPBIL_LDLRA}
\title{Structure Learning for LDLRA by PBIL algorithm}
\usage{
StrLearningPBIL_LDLRA(
  U,
  Z = NULL,
  w = NULL,
  na = NULL,
  seed = 123,
  ncls = 2,
  method = "R",
  population = 20,
  Rs = 0.5,
  Rm = 0.002,
  maxParents = 2,
  maxGeneration = 100,
  successiveLimit = 5,
  elitism = 0,
  alpha = 0.05,
  estimate = 1,
  filename = NULL,
  verbose = TRUE
)
}
\arguments{
\item{U}{U is either a data class of exametrika, or raw data. When raw data is given,
it is converted to the exametrika class with the \link{dataFormat} function.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{seed}{seed for random.}

\item{ncls}{number of latent class(rank). The default is 2.}

\item{method}{specify the model to analyze the data.Local dependence latent
class model is set to "C", latent rank model is set "R". The default is "R".}

\item{population}{Population size. The default is 20}

\item{Rs}{Survival Rate. The default is 0.5}

\item{Rm}{Mutation Rate. The default is 0.002}

\item{maxParents}{Maximum number of edges emanating from a single node. The default is 2.}

\item{maxGeneration}{Maximum number of generations.}

\item{successiveLimit}{Termination conditions. If the optimal individual does not change
for this number of generations, it is considered to have converged.}

\item{elitism}{Number of elites that remain without crossover when transitioning to
the next generation.}

\item{alpha}{Learning rate. The default is 0.05}

\item{estimate}{In PBIL for estimating the adjacency matrix, specify by number from the
following four methods: 1. Optimal adjacency matrix, 2. Rounded average of individuals in
the last generation, 3. Rounded average of survivors in the last generation, 4. Rounded
generational gene of the last generation. The default is 1.}

\item{filename}{Specify the filename when saving the generated adjacency matrix in CSV format.
The default is null, and no output is written to the file.}

\item{verbose}{verbose output Flag. default is TRUE}
}
\value{
\describe{
\item{nobs}{Sample size. The number of rows in the dataset.}
\item{testlength}{Length of the test. The number of items included in the test.}
\item{crr}{correct response ratio}
\item{adj_list}{adjacency matrix list}
\item{g_list}{graph list}
\item{referenceMatrix}{Learned Parameters.A three-dimensional array of patterns where
item x rank x pattern.}
\item{IRP}{Marginal Item Reference Matrix}
\item{IRPIndex}{IRP Indices which include Alpha, Beta, Gamma.}
\item{TRP}{Test Reference Profile matrix.}
\item{LRD}{latent Rank/Class Distribution}
\item{RMD}{Rank/Class Membership Distribution}
\item{TestFitIndices}{Overall fit index for the test.See also \link{TestFit}}
\item{Estimation_table}{Estimated parameters tables.}
\item{CCRR_table}{Correct Response Rate tables}
\item{Studens}{Student information. It includes estimated class
membership, probability of class membership, RUO, and RDO.}
}
}
\description{
Generating DAG list from data using Population-Based Incremental learning
}
\details{
This function performs structural learning for each classes by using
the Population-Based Incremental Learning model(PBIL) proposed by
Fukuda et al.(2014) within the genetic algorithm framework.
Instead of learning the adjacency matrix itself, the 'genes of genes'
that generate the adjacency matrix are updated with each generation.
For more details, please refer to Fukuda(2014) and Section
9.4.3 of the text(Shojima,2022).
}
\examples{
\donttest{
# Perform Structure Learning for LDLRA using PBIL algorithm
# This process may take considerable time due to evolutionary optimization
result.LDLRA.PBIL <- StrLearningPBIL_LDLRA(J35S515,
  seed = 123, # Set random seed for reproducibility
  ncls = 5, # Number of latent ranks
  method = "R", # Use rank model (vs. class model)
  elitism = 1, # Keep best solution in each generation
  successiveLimit = 15 # Convergence criterion
)

# Examine the learned network structure
# Plot Item Response Profiles showing item patterns across ranks
plot(result.LDLRA.PBIL, type = "IRP", nc = 4, nr = 3)

# Plot Test Response Profile showing overall response patterns
plot(result.LDLRA.PBIL, type = "TRP")

# Plot Latent Rank Distribution showing student distribution
plot(result.LDLRA.PBIL, type = "LRD")
}
}
\references{
Fukuda, S., Yamanaka, Y., & Yoshihiro, T. (2014). A Probability-based evolutionary
algorithm with mutations to learn Bayesian networks. International Journal of Artificial
Intelligence and Interactive Multimedia, 3, 7–13. DOI: 10.9781/ijimai.2014.311
}
