% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{percentile}
\alias{percentile}
\alias{percentile.default}
\alias{percentile.binary}
\title{Student Percentile Ranks}
\usage{
percentile(U, na = NULL, Z = NULL, w = NULL)

\method{percentile}{default}(U, na = NULL, Z = NULL, w = NULL)

\method{percentile}{binary}(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. Values of 1 indicate
observed responses, while 0 indicates missing data.}

\item{w}{Item weight vector specifying the relative importance of each item.}
}
\value{
A numeric vector of percentile ranks (1-100) for each student, where:
\itemize{
\item 100: Highest performing student(s)
\item 50: Median performance
\item 1: Lowest performing student(s)
}
}
\description{
The percentile function calculates each student's relative standing in the group,
expressed as a percentile rank (1-100). This function is applicable only to
binary response data.

The percentile rank indicates the percentage of scores in the distribution
that fall below a given score. For example, a percentile rank of 75 means
the student performed better than 75\% of the group.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.

Percentile ranks are calculated using the empirical cumulative distribution
function of standardized scores. Tied scores receive the same percentile rank.
The values are rounded up to the nearest integer to provide ranks from 1 to 100.
}
\examples{
# using sample dataset
percentile(J5S10)

}
