% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualtrics_data.R
\docType{data}
\name{qualtrics_fetch2}
\alias{qualtrics_fetch2}
\title{Example numeric metadata imported with \code{qualtRics::fetch_survey()} from
simulated Qualtrics study but with labels included as column names}
\format{
A data frame with 100 rows and 17 variables:
\describe{
\item{Start Date}{date and time data collection started, in ISO 8601 format}
\item{End Date}{date and time data collection ended, in ISO 8601 format}
\item{Response Type}{numeric flag for preview (1) vs. implemented survey (0)
entries}
\item{IP Address}{participant IP address (truncated for anonymity)}
\item{Progress}{percentage of survey completed}
\item{Duration (in seconds)}{duration of time required to complete survey,
in seconds}
\item{Finished}{numeric flag for whether survey was completed (1) or
progress was < 100 (0)}
\item{Recorded Date}{date and time survey was recorded, in ISO 8601 format}
\item{Response ID}{random ID for participants}
\item{Location Latitude}{latitude geolocated from IP address}
\item{Location Longitude}{longitude geolocated from IP address}
\item{User Language}{language set in Qualtrics}
\item{Click to write the question text - Browser}{user web browser type}
\item{Click to write the question text - Version}{user web browser version}
\item{Click to write the question text - Operating System}{user operating system}
\item{Click to write the question text - Resolution}{user screen resolution}
\item{like}{response to question about whether the user liked the survey
(1 = Yes, 0 = No)}
}
}
\usage{
qualtrics_fetch2
}
\description{
A dataset containing the metadata from a standard Qualtrics survey with
browser metadata collected and exported with "Use numeric values". The data
were imported using
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
and then the secondary labels were assigned as column names with
\href{https://strengejacke.github.io/sjlabelled/reference/get_label.html}{\code{sjlabelled::get_label()}}.
These data were randomly generated using \href{https://hrbrmstr.github.io/iptools/reference/ip_random.html}{iptools::ip_random()} and
\href{https://cran.r-project.org/package=rgeolocate}{rgeolocate::ip2location()} functions.
}
\seealso{
Other data: 
\code{\link{qualtrics_fetch}},
\code{\link{qualtrics_numeric}},
\code{\link{qualtrics_raw}},
\code{\link{qualtrics_text}}
}
\concept{data}
\keyword{datasets}
