% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCA_plots.R
\name{MCA_var_plot}
\alias{MCA_var_plot}
\title{Interactive MCA variables plot}
\usage{
MCA_var_plot(res, xax = 1, yax = 2, var_sup = TRUE,
  var_lab_min_contrib = 0, point_size = 64, col_var = NULL,
  symbol_var = NULL, size_var = NULL, size_range = c(10, 300),
  zoom_callback = NULL, in_explor = FALSE, ...)
}
\arguments{
\item{res}{Result of prepare_results() call}

\item{xax}{Horizontal axis number}

\item{yax}{Vertical axis number}

\item{var_sup}{TRUE to display supplementary variables}

\item{var_lab_min_contrib}{Contribution threshold to display points labels}

\item{point_size}{base point size}

\item{col_var}{name of the variable for points color}

\item{symbol_var}{name of the variable for points symbol}

\item{size_var}{name of the variable for points size}

\item{size_range}{points size range with format c(minimum, maximum)}

\item{zoom_callback}{scatterD3 zoom callback JavaScript body}

\item{in_explor}{wether the plot is to be displayed in the \code{explor} interface}

\item{...}{Other arguments passed to scatterD3}
}
\description{
This function generates an HTML widget displaying the variables plot of an MCA result.
}
\author{
Julien Barnier <julien.barnier@ens-lyon.fr>
}
