% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.2-modCluster.R
\docType{methods}
\name{modCluster}
\alias{modCluster}
\alias{modCluster,ExprsArray-method}
\title{Cluster Subjects}
\usage{
modCluster(object, top = 0, how = "hclust", onlyCluster = FALSE, ...)

\S4method{modCluster}{ExprsArray}(object, top = 0, how = "hclust",
  onlyCluster = FALSE, ...)
}
\arguments{
\item{object}{An \code{ExprsArray} object. The object containing the subject
data to cluster.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{how}{A character string. The name of the function used to cluster.
Select from "hclust", "kmeans", "agnes", "clara", "diana", "fanny", or
"pam".}

\item{onlyCluster}{A logical sclar. Toggles whether to return a processed
cluster object or an updated \code{ExprsArray} object.}

\item{...}{Additional arguments to the cluster function and/or
other functions used for clustering (e.g., \code{dist} and
\code{cutree}).}
}
\value{
Typically an \code{ExprsArray} object with subject cluster assignments
 added to the \code{$cluster} column of the \code{@anot} slot.
}
\description{
This method clusters subjects based on feature data using any one of
 seven available clustering algorithms. See Arguments below.
}
\details{
Note that this function will expect the argument \code{k} to define the returned
 number of clusters, except when \code{how = "kmeans"} in which case this
 function will expect the argument \code{centers} instead.
}
\section{Methods (by class)}{
\itemize{
\item \code{ExprsArray}: Method to compare \code{ExprsArray} objects.
}}

