% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.5-plNested.R
\name{plNested}
\alias{plNested}
\title{Nested Cross-Validation}
\usage{
plNested(array, fold = 10, ctrlFS = NULL, ctrlGS, save = FALSE)
}
\arguments{
\item{array}{Specifies the \code{ExprsArray} object to undergo cross-validation.}

\item{fold}{A numeric scalar. Specifies the number of folds for cross-validation.
Set \code{fold = 0} to perform leave-one-out cross-validation.}

\item{ctrlFS}{A list of arguments handled by \code{\link{ctrlFeatureSelect}}.}

\item{ctrlGS}{Arguments handled by \code{\link{ctrlGridSearch}}.}

\item{save}{A logical scalar. Toggles whether to save each fold.}
}
\value{
An \code{\link{ExprsPipeline-class}} object.
}
\description{
Perform nested cross-validation.
}
\details{
Analogous to how \code{\link{plGrid}} manages multiple \code{build} and
 \code{predict} tasks, one can think of \code{plNested} as managing
 multiple \code{pl} tasks.

Specifically, \code{plNested} segregates the data into v-folds,
 treating each fold as a validation set and the subjects not in that fold
 as a training set. Then, some \code{fold} times, it performs all
 feature selection tasks (listed via \code{ctrlFS}) on each split
 of the data, and executes the \code{pl} function (via \code{ctrlGS})
 using the training set.

To perform multiple feature selection tasks, supply a list of multiple
 \code{\link{ctrlFeatureSelect}} argument wrappers to \code{ctrlFS}.
 To reduce the results of \code{plNested} to a single performance metric,
 you can feed the returned \code{ExprsPipeline} object through the helper
 function \code{\link{calcNested}}.

When calculating model performance with \code{\link{calcStats}}, this
 function forces \code{aucSkip = TRUE} and \code{plotSkip = TRUE}.
 When embedding another \code{plMonteCarlo} or \code{plNested} call within
 this function (i.e., via \code{ctrlGS}), outer-fold model performance
 will force \code{aucSkip = TRUE} and \code{plotSkip = TRUE}.
}
\examples{
\dontrun{
require(golubEsets)
data(Golub_Merge)
array <- arrayEset(Golub_Merge, colBy = "ALL.AML", include = list("ALL", "AML"))
array <- modFilter(array, 20, 16000, 500, 5) # pre-filter Golub ala Deb 2003
array <- modTransform(array) # lg transform
array <- modNormalize(array, c(1, 2)) # normalize gene and subject vectors
fs <- ctrlFeatureSelect(func = "fsEbayes", top = 0)
gs <- ctrlGridSearch(func = "plGrid", how = "buildANN", top = c(10, 20, 30),
                     size = 1:3, decay = c(0, .5, 1), fold = 0)
nest <- plNested(arrays[[1]], fold = 10, ctrlFS = fs, ctrlGS = gs, save = FALSE)
}
}
