% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category.R
\name{as.category}
\alias{as.category}
\alias{is.category}
\title{Convert dichotomy data.frame/matrix to data.frame with category encoding}
\usage{
as.category(x, prefix = NULL, counted_value = 1, compress = FALSE)

is.category(x)
}
\arguments{
\item{x}{Dichotomy data.frame/matrix (usually with 0,1 coding).}

\item{prefix}{If is not NULL then column names will be added in the form
prefix+column number.}

\item{counted_value}{Vector. Values that will be considered as indicator 
of category presence. By default it equals to 1.}

\item{compress}{Logical. Should we drop columns with all NA? FALSE by 
default. TRUE significantly decreases performance of the function.}
}
\value{
data.frame of class \code{category} with numeric values
  that correspond to column numbers of counted values. Column names of x or
  variable labels are added as value labels.
}
\description{
Convert dichotomy data.frame/matrix to data.frame with category encoding
}
\examples{
set.seed(123)

# Let's imagine it's matrix of consumed products
dichotomy_matrix = matrix(sample(0:1,40,replace = TRUE,prob=c(.6,.4)),nrow=10)
colnames(dichotomy_matrix) = c("Milk","Sugar","Tea","Coffee")

as.category(dichotomy_matrix, compress = TRUE) # compressed version
category_encoding = as.category(dichotomy_matrix)

 # should be TRUE
identical(val_lab(category_encoding), c(Milk = 1L, Sugar = 2L, Tea = 3L, Coffee = 4L))
all(as.dichotomy(category_encoding, use_na = FALSE) == dichotomy_matrix)

# with prefix
as.category(dichotomy_matrix, prefix = "products_")

# data.frame with variable labels
dichotomy_dataframe = as.data.frame(dichotomy_matrix)
colnames(dichotomy_dataframe) = paste0("product_", 1:4)
var_lab(dichotomy_dataframe[[1]]) = "Milk"
var_lab(dichotomy_dataframe[[2]]) = "Sugar"
var_lab(dichotomy_dataframe[[3]]) = "Tea"
var_lab(dichotomy_dataframe[[4]]) = "Coffee"

as.category(dichotomy_dataframe, prefix = "products_")

}
\seealso{
\code{\link{as.dichotomy}} for reverse conversion, \link{mrset},
  \link{mdset} for usage multiple-response variables with tables.
}
