% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kumaraswamy-distribution.R
\name{Kumaraswamy}
\alias{Kumaraswamy}
\alias{dkumar}
\alias{pkumar}
\alias{qkumar}
\alias{rkumar}
\title{Kumaraswamy distribution}
\usage{
dkumar(x, a = 1, b = 1, log = FALSE)

pkumar(q, a = 1, b = 1, lower.tail = TRUE, log.p = FALSE)

qkumar(p, a = 1, b = 1, lower.tail = TRUE, log.p = FALSE)

rkumar(n, a = 1, b = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{a, b}{positive valued parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the Kumaraswamy distribution.
}
\details{
Probability density function
\deqn{
f(x) = abx^{a-1} (1-x^a)^{b-1}
}{
f(x) = a*b*x^{a-1}*(1-x^a)^{b-1}
}

Cumulative distribution function
\deqn{
F(x) = 1-(1-x^a)^b
}{
F(x) = 1-(1-x^a)^b
}

Quantile function
\deqn{
F^{-1}(p) = 1-(1-p^{1/b})^{1/a}
}{
F^-1(p) = 1-(1-p^{1/b})^{1/a}
}
}
\examples{

x <- rkumar(1e5, 5, 16)
xx <- seq(0, 1, by = 0.001)
hist(x, 100, freq = FALSE)
lines(xx, dkumar(xx, 5, 16), col = "red")
hist(pkumar(x, 5, 16))
plot(ecdf(x))
lines(xx, pkumar(xx, 5, 16), col = "red", lwd = 2)

}
\references{
Jones, M. C. (2009). Kumaraswamy's distribution: A beta-type distribution with
some tractability advantages. Statistical Methodology, 6, 70-81.

Cordeiro, G.M. and de Castro, M. (2009). A new family of generalized distributions.
Journal of Statistical Computation & Simulation, 1-17.
}
\keyword{distribution}

