% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhattacharjee-distribution.R
\name{Bhattacharjee}
\alias{Bhattacharjee}
\alias{dbhatt}
\alias{pbhatt}
\alias{rbhatt}
\title{Bhattacharjee distribution}
\usage{
dbhatt(x, mu = 0, sigma = 1, a = sigma, log = FALSE)

pbhatt(q, mu = 0, sigma = 1, a = sigma, lower.tail = TRUE,
  log.p = FALSE)

rbhatt(n, mu = 0, sigma = 1, a = sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu, sigma, a}{location, scale and shape parameters.
Scale and shape must be positive.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, and random generation for the Bhattacharjee
distribution.
}
\details{
If \eqn{Z \sim \mathrm{Normal}(0, 1)}{Z ~ Normal(0, 1)} and
\eqn{U \sim \mathrm{Uniform}(0, 1)}{U ~ Uniform(0, 1)}, then
\eqn{Z+U} follows Bhattacharjee distribution.

Probability density function

\deqn{
f(z) = \frac{1}{2a} \left[\Phi\left(\frac{x-\mu+a}{\sigma}\right) - \Phi\left(\frac{x-\mu-a}{\sigma}\right)\right]
}{
f(z) = 1/(2*a) * (\Phi((x-\mu+a)/\sigma) - \Phi((x-\mu+a)/\sigma))
}

Cumulative distribution function

\deqn{
F(z) = \frac{\sigma}{2a} \left[(x-\mu)\Phi\left(\frac{x-\mu+a}{\sigma}\right) -
                               (x-\mu)\Phi\left(\frac{x-\mu-a}{\sigma}\right) +
                               \phi\left(\frac{x-\mu+a}{\sigma}\right) -
                               \phi\left(\frac{x-\mu-a}{\sigma}\right)\right]
}{
F(z) = \sigma/(2*a) * ((x-\mu)*\Phi((x-\mu+a)/\sigma) - (x-\mu)*\Phi((x-\mu-a)/\sigma) +
                       \phi((x-\mu+a)/\sigma) - \phi((x-\mu-a)/\sigma))
}
}
\examples{

x <- rbhatt(1e5, 5, 3, 5)
xx <- seq(-20, 20, by = 0.01)
hist(x, 100, freq = FALSE)
lines(xx, dbhatt(xx, 5, 3, 5), col = "red")
hist(pbhatt(x, 5, 3, 5))
plot(ecdf(x))
lines(xx, pbhatt(xx, 5, 3, 5), col = "red", lwd = 2)

}
\references{
Bhattacharjee, G.P., Pandit, S.N.N., and Mohan, R. (1963).
Dimensional chains involving rectangular and normal error-distributions.
Technometrics, 5, 404-406.
}
\keyword{distribution}
