% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half-cauchy-distribution.R
\name{HalfCauchy}
\alias{HalfCauchy}
\alias{dhcauchy}
\alias{phcauchy}
\alias{qhcauchy}
\alias{rhcauchy}
\title{Half-Cauchy distribution}
\usage{
dhcauchy(x, sigma = 1, log = FALSE)

phcauchy(q, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qhcauchy(p, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rhcauchy(n, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{sigma}{positive valued scale parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Density, distribution function, quantile function and random generation
for the half-Cauchy distribution.
}
\details{
If \eqn{X} follows Cauchy centered at 0 and parametrized by scale \eqn{\sigma},
then \eqn{|X|} follows half-Cauchy distribution parametrized by
scale \eqn{\sigma}. Half-Cauchy distribution is a special case of half-t
distribution with \eqn{\nu=1} degrees of freedom.
}
\examples{

x <- rhcauchy(1e5, 2)
hist(x, 2e5, freq = FALSE, xlim = c(0, 100))
curve(dhcauchy(x, 2), 0, 100, col = "red", add = TRUE)
hist(phcauchy(x, 2))
plot(ecdf(x), xlim = c(0, 100))
curve(phcauchy(x, 2), col = "red", lwd = 2, add = TRUE)

}
\references{
Gelman, A. (2006). Prior distributions for variance parameters in hierarchical
models (comment on article by Browne and Draper).
Bayesian analysis, 1(3), 515-534.

Jacob, E. and Jayakumar, K. (2012).
On Half-Cauchy Distribution and Process.
International Journal of Statistika and Mathematika, 3(2), 77-81.
}
\seealso{
\code{\link{HalfT}}
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
