% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower.R
\name{lower}
\alias{lower}
\title{Lower Credible Limit}
\usage{
lower(x, conf_level = 0.95, na_rm = FALSE)
}
\arguments{
\item{x}{A numeric vector of MCMC values.}

\item{conf_level}{A numeric scalar between 0 and 1
specifying the confidence level.}

\item{na_rm}{A flag specifying whether to remove missing values.}
}
\value{
A number.
}
\description{
Calculates the quantile-based lower credible limit.
}
\details{
By default it returns the 95\% credible limit which
corresponds to the 2.5\% quantile.
}
\examples{
lower(as.numeric(0:100))
}
\seealso{
Other summary: 
\code{\link{kurtosis}()},
\code{\link{pvalue}()},
\code{\link{skewness}()},
\code{\link{svalue}()},
\code{\link{upper}()},
\code{\link{variance}()},
\code{\link{xtr_mean}()},
\code{\link{xtr_median}()},
\code{\link{xtr_sd}()},
\code{\link{zeros}()},
\code{\link{zscore}()}
}
\concept{summary}
