% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{plot.hill.adapt}
\alias{plot.hill.adapt}
\title{Hill.adapt Plot}
\usage{
\method{plot}{hill.adapt}(x, ...)
}
\arguments{
\item{x}{output object of the function hill.adapt.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Graphical representation of the hill.adapt function last iteration
}
\details{
The weighted hill estimator, the test statistic, the penalized likelihood graphs of the last iteration and the survival function are given. The blue line corresponds to the threshold (indice or value). The magenta lines correspond to the window (r1, r2) where the estimation is computed. The red lines corresponds to the initial proportion (initprop) and the last non rejected point of the statistic test (madapt).
}
\examples{

x <- abs(rcauchy(100))
HH <- hill.adapt(x, weights=rep(1, length(x)), initprop = 0.1,
               gridlen = 50 , r1 = 0.25, r2 = 0.05, CritVal=10)
plot(HH)


}
\seealso{
\code{\link{hill.adapt}}, \code{\link{plot}}
}

