% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{bootCI}
\alias{bootCI}
\title{Pointwise confidence intervals by bootstrap}
\usage{
bootCI(X, weights = rep(1, length(X)), probs = 1:(length(X) - 1)/length(X),
  xgrid = sort(X), B = 100, alpha = 0.05, type = "quantile",
  CritVal = 10, initprop = 1/10, gridlen = 100, r1 = 1/4, r2 = 1/20,
  plot = F)
}
\arguments{
\item{X}{a numeric vector of data values.}

\item{weights}{a numeric vector of weights.}

\item{probs}{used if type = "quantile", a numeric vector of probabilities with values in \eqn{[0,1]}.}

\item{xgrid}{used if type = "survival", a numeric vector with values in the domain of X.}

\item{B}{an integer giving the number of bootstrap iterations.}

\item{alpha}{the type 1 error of the bootstrap (1-\eqn{alpha})-confidence interval.}

\item{type}{type is either "quantile" or "survival".}

\item{CritVal}{a critical value associated to the kernel function given by \code{\link{CriticalValue}}. The default value is 10 corresponding to the rectangular kernel.}

\item{gridlen, initprop, r1, r2}{parameters used in the function hill.adapt (see \code{\link{hill.adapt}}).}

\item{plot}{If \code{TRUE}, the bootstrap confidence interval is plotted.}
}
\value{
\item{LowBound}{the lower bound of the bootstrap (1-\eqn{alpha})-confidence interval.}
\item{UppBound}{the upper bound of the bootstrap (1-\eqn{alpha})-confidence interval of level.}
}
\description{
Pointwise quantiles and survival probabilities confidence intervals using bootstrap.
}
\details{
Generate B samples of \eqn{X} with replacement to estimate the quantiles of orders \eqn{probs} or the survival probability corresponding to \eqn{xgrid}. Determine the bootstrap pointwise (1-\eqn{alpha})-confidence interval for the quantiles or the survival probabilities.
}
\examples{
X <- abs(rcauchy(400))
hh <- hill.adapt(X)
probs <- probgrid(0.1, 0.999999, length = 100)
B <- 200
\dontrun{ #For computing time purpose
  bootCI(X, weights = rep(1, length(X)), probs = probs, B = B, plot = TRUE)
  xgrid <- sort(sample(X, 100))
  bootCI(X, weights = rep(1, length(X)), xgrid = xgrid, type = "survival", B = B, plot = TRUE)
}

}
\seealso{
\code{\link{hill.adapt}},\code{\link{CriticalValue}},\code{\link{predict.hill.adapt}}
}
