% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{predict.hill.ts}
\alias{predict.hill.ts}
\title{Predict the adaptive survival or quantile function for a time serie}
\usage{
\method{predict}{hill.ts}(object, newdata = NULL, type = "quantile",
  input = NULL, ...)
}
\arguments{
\item{object}{output object of the function hill.ts.}

\item{newdata}{optionally, a data frame or a vector with which to predict. If omitted, the original data points are used.}

\item{type}{either "quantile" or "survival".}

\item{input}{optionnaly, the name of the variable to estimate.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{p}{the input vector of probabilities.}
  \item{x}{the input vector of values.}
  \item{Tgrid}{Tgrid output of the function hill.ts.}
  \item{quantiles}{the estimted quantiles assiociated to newdata.}
  \item{survival}{the estimated survival function assiociated to newdata.}
}
\description{
Give the adaptive survival function or quantile function of a time serie
}
\details{
If type = "quantile", \eqn{newdata} must be between 0 and 1. If type = "survival", \eqn{newdata} must be in the domain of the data from the function \code{hill.ts}.
If \eqn{newdata} is a data frame, the variable from which to predict must be the first one or its name must start with a "p" if type = "quantile" and "x" if type = "survival".
The name of the variable from which to predict can also be written as \eqn{input}.
}
\examples{
#Generate a pareto mixture sample of size n with a time varying parameter
theta <- function(t){
   0.5+0.25*sin(2*pi*t)
 }
n <- 4000
t <- 1:n/n
Theta <- theta(t)
Data <- NULL
set.seed(1240)
for(i in 1:n){
   Data[i] <- rparetomix(1, a = 1/Theta[i], b = 1/Theta[i]+5, c = 0.75, precision = 10^(-5))
 }
\dontrun{ #For computing time purpose
  #choose the bandwidth by cross validation
  Tgrid <- seq(0, 1, 0.1)#few points to improve the computing time
  hgrid <- bandwidth.grid(0.01, 0.2, 20, type = "geometric")
  hcv <- bandwidth.CV(Data, t, Tgrid, hgrid, TruncGauss.kernel,
         kpar = c(sigma = 1), pcv = 0.99, CritVal = 3.6, plot = TRUE)
  h.cv <- hcv$h.cv

  #we modify the Tgrid to cover the data set
  Tgrid <- seq(0, 1, 0.02)
  hillTs <- hill.ts(Data, t, Tgrid, h = h.cv, TruncGauss.kernel, kpar = c(sigma = 1),
           CritVal = 3.6, gridlen = 100, initprop = 1/10, r1 = 1/4, r2 = 1/20)
  p <- c(0.999)
  pred.quantile.ts <- predict(hillTs, newdata = p, type = "quantile")
  true.quantile <- NULL
  for(i in 1:n){
     true.quantile[i] <- qparetomix(p, a = 1/Theta[i], b = 1/Theta[i]+5, c = 0.75)
   }
  plot(Tgrid, log(as.numeric(pred.quantile.ts$y)),
       ylim = c(0, max(log(as.numeric(pred.quantile.ts$y)))), ylab = "log(0.999-quantiles)")
  lines(t, log(true.quantile), col = "red")
  lines(t, log(Data), col = "blue")


  #comparison with other fixed bandwidths

  plot(Tgrid, log(as.numeric(pred.quantile.ts$y)),
       ylim = c(0, max(log(as.numeric(pred.quantile.ts$y)))), ylab = "log(0.999-quantiles)")
  lines(t, log(true.quantile), col = "red")

  hillTs <- hill.ts(Data, t, Tgrid, h = 0.1, TruncGauss.kernel, kpar = c(sigma = 1),
                    CritVal = 3.6, gridlen = 100,initprop = 1/10, r1 = 1/4, r2 = 1/20)
  pred.quantile.ts <- predict(hillTs, p, type = "quantile")
  lines(Tgrid, log(as.numeric(pred.quantile.ts$y)), col = "green")


  hillTs <- hill.ts(Data, t, Tgrid, h = 0.3, TruncGauss.kernel, kpar = c(sigma = 1),
               CritVal = 3.6, gridlen = 100, initprop = 1/10, r1 = 1/4, r2 = 1/20)
  pred.quantile.ts <- predict(hillTs, p, type = "quantile")
  lines(Tgrid, log(as.numeric(pred.quantile.ts$y)), col = "blue")


  hillTs <- hill.ts(Data, t, Tgrid, h = 0.04, TruncGauss.kernel, kpar = c(sigma = 1),
             CritVal = 3.6, gridlen = 100, initprop = 1/10, r1 = 1/4, r2 = 1/20)
  pred.quantile.ts <- predict(hillTs ,p, type = "quantile")
  lines(Tgrid, log(as.numeric(pred.quantile.ts$y)), col = "magenta")
}



}
\seealso{
\code{\link{hill.ts}}
}
