% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{bandwidth.grid}
\alias{bandwidth.grid}
\title{Bandwidth Grid}
\usage{
bandwidth.grid(hmin, hmax, length = 20, type = "geometric")
}
\arguments{
\item{hmin}{the minimum value of the grid.}

\item{hmax}{the maximum value of the grid.}

\item{length}{the length of the grid.}

\item{type}{the type of grid, either \eqn{geometric} or \eqn{uniform}.}
}
\value{
Return a geometric or uniform grid of size \eqn{length} between \eqn{hmin} and \eqn{hmax}.
}
\description{
Create either a geometric or an uniform grid of bandwidths between two values
}
\details{
The geometric grid is defined by:
\deqn{
  grid(l) = hmin * exp( ( log(hmax)-log(hmin) ) / (length -1) ) ^ l  ,  l = 0 , ... , (length -1)
}
}
\examples{
hmin <- 0.05
hmax <- 0.2
length <- 20
(h.geometric <- bandwidth.grid(hmin, hmax, length, type = "geometric"))
(h.uniform <- bandwidth.grid(hmin, hmax, length, type = "uniform"))

}
