% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datestamp.R
\name{datestamp}
\alias{datestamp}
\alias{datestamp.radf_obj}
\title{Date-stamping periods of mildly explosive behavior}
\usage{
datestamp(object, cv = NULL, min_duration = 0L, ...)

\method{datestamp}{radf_obj}(
  object,
  cv = NULL,
  min_duration = 0L,
  option = c("gsadf", "sadf"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{obj}.}

\item{cv}{An object of class \code{cv}.}

\item{min_duration}{The minimum duration of an explosive period for it to be
reported (default = 0).}

\item{...}{further arguments passed to methods.}

\item{option}{Whether to apply the "gsadf" or "sadf" methodology (default = "gsadf").}
}
\value{
Returns a list containing the estimated origination and termination
dates of  episodes of explosive behaviour and the corresponding duration.
}
\description{
Computes the origination, termination and duration of
episodes during which the time series display explosive dynamics.
}
\details{
Datestamp also stores a vector whose elements take the value of 1 when there is
a period of explosive behaviour and 0 otherwise. This output can serve as a
dummy variable for the occurrence of exuberance.
}
\examples{

rsim_data <- radf(sim_data)

ds_data <- datestamp(rsim_data)
ds_data

# Choose minimum window
datestamp(rsim_data, min_duration = psy_ds(nrow(sim_data)))

autoplot(ds_data)
}
\references{
Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for
Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the
S&P 500. International Economic Review, 56(4), 1043-1078.
}
