% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{Convenient function for viewing any rectangular data file in an Excel window.}
\usage{
view(x, mode = NULL, ...)
}
\arguments{
\item{x}{An object of class data.frame, matrix, or vector.}

\item{mode}{Character value for session locale and encoding; available values are: "ko1" for "CP949"; "ko2" for "UTF-8" while both change R locale into Korean (default is the current locale and encoding of your R session).}

\item{...}{Any additional arguments available for \link[readr]{write_csv}.}
}
\value{
Data object opened in a preferable spreadsheet application window.
}
\description{
You can use this function for loading any data.frame, data_frame, tbl_df, matrix, vector objects into your system-default spreadsheet software (e.g., Excel). This function has been inspired by \code{\link[BrailleR]{DataViewer}} and has implemented Hadley Wickham's \code{\link[readr]{write_csv}} instead of the default \code{\link[utils]{write.csv}} for a better performance.
}
\details{
view


See example below.
}
\examples{
if(interactive()) {
library(ezpickr)
data(airquality)
str(airquality)
## View your data object in your spreadsheet software:
# Please use additional argument: either `mode="ko1"` or `mode="ko2"` for Korean dataset.
view(airquality)
# Then, when necessary, you can modify the opened data in the spreadsheet and save it as a new data.
}
}
\author{
JooYoung Seo, \email{jooyoung@psu.edu}

Soyoung Choi, \email{sxc940@psu.edu}
}
\keyword{view}
