% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewxl.R
\name{viewxl}
\alias{viewxl}
\title{Seamlessly manipulate any rectangular data file between an Excel window and R session.}
\usage{
viewxl(x, ...)
}
\arguments{
\item{x}{An object of class data.frame, matrix, table, vector, or DocumentTermMatrix.}

\item{...}{Any additional arguments available for \link[writexl]{write_xlsx}.}
}
\value{
Data object opened in a preferable spreadsheet application window which will in turn be called on your R session again.
}
\description{
You can use this function for loading and manipulating any data.frame, data_frame, tbl_df, matrix, table, vector, or DocumentTermMatrix objects into your system-default spreadsheet software (e.g., Excel) in a real time. This function has employed \code{\link[writexl]{write_xlsx}} under the hood.
}
\details{
viewxl


See example below.
}
\examples{
if (interactive()) {
  library(ezpickr)
  data(airquality)
  str(airquality)

  ## View your data object in your spreadsheet software:
  viewxl(airquality)
  # Then, when necessary, you can modify the opened data 
  # in the spreadsheet and save it as a new data.

  # You can pass a list object to the `view()` function like below:
  l <- list(iris = iris, mtcars = mtcars, chickwts = chickwts, quakes = quakes)
  viewxl(l)
  # Then, each list item will appear in your Excel window sheet by sheet.
}
}
\author{
JooYoung Seo, \email{jooyoung@psu.edu}

Soyoung Choi, \email{sxc940@psu.edu}
}
\keyword{viewxl}
