% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{unitroot_options}
\alias{unitroot_options}
\title{Options for the unit root tests for order of integration}
\usage{
unitroot_options(
  ndiffs_alpha = 0.05,
  nsdiffs_alpha = 0.05,
  ndiffs_pvalue = ~feasts::unitroot_kpss(.)["kpss_pvalue"],
  nsdiffs_pvalue = ur_seasonal_strength(0.64)
)
}
\arguments{
\item{ndiffs_alpha, nsdiffs_alpha}{The level for the test specified in the \code{pval} functions As long as \code{pval < alpha}, differences will be added.}

\item{ndiffs_pvalue, nsdiffs_pvalue}{A function (or lambda expression) which returns the probability of the . As long as \code{pval < alpha}, differences will be added.

For the function for the seasonal p-value, the seasonal period will be provided as the \code{.period} argument to this function.
A vector of data to test is available as \code{.} or \code{.x}.}
}
\value{
A list of parameters
}
\description{
By default, a kpss test (via \code{\link[feasts:unitroot]{feasts::unitroot_kpss()}}) will be performed
for testing the required first order differences, and a test of the seasonal
strength (via \code{\link[feasts:feat_stl]{feasts::feat_stl()}} seasonal_strength) being above the 0.64
threshold is used for determining seasonal required differences.
}
