% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{glance.VAR}
\alias{glance.VAR}
\title{Glance a VAR}
\usage{
\method{glance}{VAR}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
Construct a single row summary of the VAR model.
}
\details{
Contains the variance of residuals (\code{sigma2}), the log-likelihood (\code{log_lik}),
and information criterion (\code{AIC}, \code{AICc}, \code{BIC}).
}
\examples{
lung_deaths <- cbind(mdeaths, fdeaths) \%>\%
  as_tsibble(pivot_longer = FALSE)

lung_deaths \%>\%
  model(VAR(vars(mdeaths, fdeaths) ~ AR(3))) \%>\%
  glance()
}
