% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fviz_mfa.R
\name{fviz_mfa}
\alias{fviz_mfa}
\alias{fviz_mfa_axes}
\alias{fviz_mfa_group}
\alias{fviz_mfa_ind}
\alias{fviz_mfa_ind_starplot}
\alias{fviz_mfa_quali_biplot}
\alias{fviz_mfa_quali_var}
\alias{fviz_mfa_quanti_var}
\title{Visualize Multiple Factor Analysis}
\usage{
fviz_mfa_ind(X, axes = c(1, 2), geom = c("point", "text"), label = "all",
  invisible = "none", labelsize = 4, pointsize = 2, habillage = "none",
  addEllipses = FALSE, ellipse.level = 0.95, ellipse.type = "norm",
  ellipse.alpha = 0.1, col.ind = "blue", col.ind.sup = "darkblue",
  alpha.ind = 1, shape.ind = 19, repel = FALSE,
  axes.linetype = "dashed", select.ind = list(name = NULL, cos2 = NULL,
  contrib = NULL), title = "Individuals factor map - MFA",
  jitter = list(what = "label", width = NULL, height = NULL), ...)

fviz_mfa_quanti_var(X, axes = c(1, 2), geom = c("arrow", "text"),
  label = "all", invisible = "none", labelsize = 4, pointsize = 2,
  col.var = "red", alpha.var = 1, shape.var = 17,
  col.quanti.sup = "blue", col.quali.sup = "darkgreen",
  col.circle = "grey70", select.var = list(name = NULL, cos2 = NULL, contrib
  = NULL), axes.linetype = "dashed",
  title = "Quantitative Variable categories - MFA", repel = FALSE,
  jitter = list(what = "label", width = NULL, height = NULL))

fviz_mfa_quali_var(X, axes = c(1, 2), geom = c("point", "text"),
  label = "all", invisible = "none", labelsize = 4, pointsize = 2,
  col.var = "red", alpha.var = 1, shape.var = 17,
  col.quanti.sup = "blue", col.quali.sup = "darkgreen", repel = FALSE,
  select.var = list(name = NULL, cos2 = NULL, contrib = NULL),
  axes.linetype = "dashed", title = "Qualitative Variable categories - MFA",
  jitter = list(what = "label", width = NULL, height = NULL))

fviz_mfa_quali_biplot(X, axes = c(1, 2), geom = c("point", "text"),
  label = "all", invisible = "none", labelsize = 4, pointsize = 2,
  habillage = "none", addEllipses = FALSE, ellipse.level = 0.95,
  col.ind = "blue", col.ind.sup = "darkblue", alpha.ind = 1,
  col.var = "red", alpha.var = 1, col.quanti.sup = "blue",
  col.quali.sup = "darkgreen", shape.ind = 19, shape.var = 17,
  select.var = list(name = NULL, cos2 = NULL, contrib = NULL),
  select.ind = list(name = NULL, cos2 = NULL, contrib = NULL),
  axes.linetype = "dashed", title = "MFA factor map - Biplot",
  arrows = c(FALSE, FALSE), repel = FALSE, jitter = list(what = "label",
  width = NULL, height = NULL), ...)

fviz_mfa_ind_starplot(X, axes = c(1, 2), geom = c("point", "text"),
  label = "all", invisible = "none", legend.partial.title = NULL,
  labelsize = 4, pointsize = 2, linesize = 0.5, repel = FALSE,
  habillage = "none", addEllipses = FALSE, ellipse.level = 0.95,
  ellipse.type = "norm", ellipse.alpha = 0.1, col.ind = "black",
  col.ind.sup = "darkblue", col.partial = "black", alpha.ind = 1,
  shape.ind = 19, alpha.partial = 1, select.ind = list(name = NULL, cos2 =
  NULL, contrib = NULL), select.partial = list(name = NULL, cos2 = NULL,
  contrib = NULL), axes.linetype = "dashed",
  title = "Individuals factor map - MFA", jitter = list(what = "label",
  width = NULL, height = NULL), ...)

fviz_mfa_group(X, axes = c(1, 2), geom = c("point", "text"),
  alpha.group = 1, shape.group = 17, label = "all", invisible = "none",
  labelsize = 4, pointsize = 2, col.group = "blue",
  col.group.sup = "darkgreen", repel = FALSE, select.group = list(name =
  NULL, cos2 = NULL, contrib = NULL), title = "MFA - Groups Representations",
  jitter = list(what = "label", width = NULL, height = NULL), ...)

fviz_mfa_axes(X, axes = c(1, 2), geom = c("arrow", "text"), label = "all",
  invisible = "none", labelsize = 4, pointsize = 2, col.axes = "red",
  alpha.axes = 1, col.circle = "grey70", select.axes = list(name = NULL,
  contrib = NULL), axes.linetype = "dashed",
  title = "MFA - Partial Axes Representations", arrows = c(FALSE, FALSE),
  repel = FALSE, jitter = list(what = "label", width = NULL, height = NULL),
  ...)

fviz_mfa(X, ...)
}
\arguments{
\item{X}{an object of class MFA [FactoMineR].}

\item{axes}{a numeric vector of length 2 specifying the dimensions to be 
plotted.}

\item{geom}{a text specifying the geometry to be used for the graph. Allowed 
values are the combination of c("point", "arrow", "text"). Use "point" (to 
show only points); "text" to show only labels; c("point", "text") or 
c("arrow", "text") to show both types.}

\item{label}{a text specifying the elements to be labelled.
 Default value is "all".
 Allowed values are "none" or the combination of c("ind", "ind.sup","var", "quali.sup",  "quanti.sup").
 "ind" can be used to label only active individuals.
 "ind.sup" is for supplementary individuals.
"var" is for active variable categories.
 "quali.sup" is for supplementary qualitative variable categories.
"quanti.sup" is for quantitative supplementary variables.}

\item{invisible}{a text specifying the elements to be hidden on the plot.
Default value is "none".
Allowed values are the combination of c("ind", "ind.sup","var", "quali.sup",  "quanti.sup").}

\item{labelsize}{font size for the labels}

\item{pointsize}{the size of points}

\item{habillage}{an optional factor variable for coloring
the observations by groups. Default value is "none".
If X is an MFA object from FactoMineR package, habillage can also specify
the index of the factor variable in the data.}

\item{addEllipses}{logical value. If TRUE, draws ellipses around the 
individuals when habillage != "none".}

\item{ellipse.level}{the size of the concentration ellipse in normal 
probability.}

\item{ellipse.type}{Character specifying frame type. Possible values are 
'convex' or types supporeted by \code{\link[ggplot2]{stat_ellipse}} 
including one of c("t", "norm", "euclid").}

\item{ellipse.alpha}{Alpha for ellipse specifying the transparency level of 
fill color. Use alpha = 0 for no fill color.}

\item{col.ind, col.partial, col.var, col.group, col.group.sup, col.axes}{color for individuals, partial individuals, variables, 
groups and axes, respectively.
 Possible values include also : "cos2", "contrib", "coord", "x" or "y".
 In this case, the colors for individuals/variables are automatically controlled by their qualities ("cos2"),
 contributions ("contrib"), coordinates (x^2 + y^2 , "coord"), x values("x") or y values("y").
 To use automatic coloring (by cos2, contrib, ....), make sure that habillage ="none".}

\item{col.ind.sup}{color for supplementary individuals}

\item{alpha.ind, alpha.partial, alpha.var, alpha.group, alpha.axes}{controls the transparency of
 individual, partial individual, variable, group and axes colors, respectively.
The value can variate from 0 (total transparency) to 1 (no transparency).
Default value is 1. Possible values include also : "cos2", "contrib", "coord", "x" or "y".
 In this case, the transparency for individual/variable colors are automatically controlled by their qualities ("cos2"),
 contributions ("contrib"), coordinates (x^2 + y^2 , "coord"), x values("x") or y values("y").
 To use this, make sure that habillage ="none".}

\item{shape.ind, shape.var, shape.group}{point shapes of individuals, variables, groups and axes}

\item{repel}{a boolean, whether to use ggrepel to avoid overplotting text labels or not.}

\item{axes.linetype}{linetype of x and y axes.}

\item{select.ind, select.partial, select.var, select.group, select.axes}{a selection of individuals/partial individuals/
variables/groups/axes to be drawn.
Allowed values are NULL or a list containing the arguments name, cos2 or contrib:
\itemize{
\item name is a character vector containing individuals/variables to be drawn
\item cos2 if cos2 is in [0, 1], ex: 0.6, then individuals/variables with a cos2 > 0.6 are drawn.
if cos2 > 1, ex: 5, then the top 5 individuals/variables with the highest cos2 are drawn.
\item contrib if contrib > 1, ex: 5,  then the top 5 individuals/variables with the highest cos2 are drawn
}}

\item{title}{the title of the graph}

\item{jitter}{a parameter used to jitter the points in order to reduce overplotting. 
It's a list containing the objects what, width and height (i.e jitter = list(what, width, height)).
\itemize{
\item what: the element to be jittered. Possible values are "point" or "p"; "label" or "l"; "both" or "b"
\item width: degree of jitter in x direction
\item height: degree of jitter in y direction
}}

\item{...}{Arguments to be passed to the function fviz_mfa_quali_biplot()}

\item{col.quanti.sup, col.quali.sup}{a color for the quantitative/qualitative supplementary variables.}

\item{col.circle}{a color for the correlation circle.}

\item{arrows}{Vector of two logicals specifying if the plot should contain
points (FALSE, default) or arrows (TRUE).
First value sets the rows and the second value sets the columns.}

\item{legend.partial.title}{the title of the partal groups legend.}

\item{linesize}{size of partial point connecting line.}
}
\value{
a ggplot2 plot
}
\description{
Graph of individuals/quantitative variables/qualitative variables/group/partial axes from the output of Multiple Factor Analysis (MFA).\cr\cr
\itemize{
\item{fviz_mfa_ind(): Graph of individuals}
\item{fviz_mfa_ind_starplot(): Star graph of individuals}
\item{fviz_mfa_quanti_var(): Graph of quantitative variables}
\item{fviz_mfa_quali_var(): Graph of qualitative variables}
\item{fviz_mfa_quali_biplot(): Biplot of individuals and qualitative variables}
\item{fviz_mfa_group(): Graph of the groups representation}
\item{fviz_mfa_axes(): Graph of partial axes}
\item{fviz_mfa(): An alias of fviz_mfa_ind_starplot()}
}
}
\examples{
# Multiple Factor Analysis
# ++++++++++++++++++++++++
# Install and load FactoMineR to compute MFA
# install.packages("FactoMineR")
library("FactoMineR")
data(poison)
res.mfa <- MFA(poison, group=c(2,2,5,6), type=c("s","n","n","n"),
               name.group=c("desc","desc2","symptom","eat"),
               num.group.sup=1:2, graph=FALSE)

# Graph of individuals
# ++++++++++++++++++++

# Default plot
# Use repel = TRUE to avoid overplotting (slow if many points)
# Color of individuals: col.ind = "#2E9FDF"
fviz_mfa_ind(res.mfa, repel = TRUE, col.ind = "#2E9FDF")+
theme_minimal()
   
\dontrun{
# 1. Control automatically the color of individuals 
   # using the "cos2" or the contributions "contrib"
   # cos2 = the quality of the individuals on the factor map
# 2. To keep only point or text use geom = "point" or geom = "text".
# 3. Change themes: http://www.sthda.com/english/wiki/ggplot2-themes

fviz_mfa_ind(res.mfa, col.ind = "cos2")+
 theme_minimal()

# Change gradient color
# Use repel = TRUE to avoid overplotting (slow if many points)
fviz_mfa_ind(res.mfa, col.ind="cos2", repel = TRUE) + 
      scale_color_gradient2(low = "white", mid = "#2E9FDF", 
      high= "#FC4E07", midpoint=0.4, space = "Lab")+
 theme_minimal()
}

# Color individuals by groups, add concentration ellipses
# Remove labels: label = "none".
grp <- as.factor(poison[, "Vomiting"])
p <- fviz_mfa_ind(res.mfa, label="none", habillage=grp,
       addEllipses=TRUE, ellipse.level=0.95)
print(p)
 
 \dontrun{
# Change group colors using RColorBrewer color palettes
# Read more: http://www.sthda.com/english/wiki/ggplot2-colors
p + scale_color_brewer(palette="Paired") +
    scale_fill_brewer(palette="Paired") +
     theme_minimal()
 }
     
# Change group colors manually
# Read more: http://www.sthda.com/english/wiki/ggplot2-colors
p + scale_color_manual(values=c("#999999", "#E69F00"))+
 scale_fill_manual(values=c("#999999", "#E69F00"))+
 theme_minimal()  
 
 \dontrun{
# Select and visualize some individuals (ind) with select.ind argument.
 # - ind with cos2 >= 0.4: select.ind = list(cos2 = 0.4)
 # - Top 20 ind according to the cos2: select.ind = list(cos2 = 20)
 # - Top 20 contributing individuals: select.ind = list(contrib = 20)
 # - Select ind by names: select.ind = list(name = c("44", "38", "53",  "39") )
 
# Example: Select the top 20 according to the cos2
fviz_mfa_ind(res.mfa, select.ind = list(cos2 = 20))
}

# Graph of qantitative variable categories
# ++++++++++++++++++++++++++++++++++++++++
data(wine)
res.mfa <- MFA(wine, group=c(2,5,3,10,9,2), type=c("n",rep("s",5)),
               ncp=5, name.group=c("orig","olf","vis","olfag","gust","ens"),
               num.group.sup=c(1,6), graph=FALSE)
               
# Default plot
fviz_mfa_quanti_var(res.mfa, col.var = "#FC4E07")+
theme_minimal()
   
\dontrun{
# Control variable colors using their contributions
fviz_mfa_quanti_var(res.mfa, col.var = "contrib")+
 scale_color_gradient2(low = "white", mid = "blue",
           high = "red", midpoint = 20) +
 theme_minimal()
 
# Select variables with select.var argument
   # You can select by contrib, cos2 and name 
   # as previously described for ind
# Select the top 10 contributing variables
fviz_mfa_quanti_var(res.mfa, select.var = list(contrib = 10))
}
 
# Graph of categorical variable categories
# ++++++++++++++++++++++++++++++++++++++++
data(poison)
res.mfa <- MFA(poison, group=c(2,2,5,6), type=c("s","n","n","n"),
               name.group=c("desc","desc2","symptom","eat"),
               num.group.sup=1:2, graph=FALSE)

# Plot
# Control variable colors using their contributions
fviz_mfa_quali_var(res.mfa, col.var = "contrib")+
 scale_color_gradient2(low = "white", mid = "blue",
           high = "red", midpoint = 2) +
 theme_minimal()
 
 
 \dontrun{
# Select the top 10 contributing variable categories
fviz_mfa_quali_var(res.mfa, select.var = list(contrib = 10))
}


# Biplot of categorical variable categories and individuals
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 # Use repel = TRUE to avoid overplotting
grp <- as.factor(poison[, "Vomiting"])
fviz_mfa_quali_biplot(res.mfa, repel = FALSE, col.var = "#E7B800",
   habillage = grp, addEllipses = TRUE, ellipse.level = 0.95)+
 theme_minimal()

               
# Graph of partial individuals (starplot)
# +++++++++++++++++++++++++++++++++++++++
fviz_mfa_ind_starplot(res.mfa, col.partial = "group.name")+
scale_color_brewer(palette = "Dark2")+
theme_minimal()

\dontrun{
# Select the partial points of the top 5
# contributing individuals
fviz_mfa_ind_starplot(res.mfa, 
                      select.partial = list(contrib = 2)) +
                      theme_minimal()
                      
# Change colours of star segments
fviz_mfa_ind_starplot(res.mfa, select.partial = list(contrib = 5), 
                      col.partial = "group.name") +
                      scale_color_brewer(palette = "Dark2") +
                      theme_minimal() 
}

 
# Graph of groups (correlation square)
# ++++++++++++++++++++++++++++++++++++
fviz_mfa_group(res.mfa)

#' # Graph of partial axes
# ++++++++++++++++++++++++
fviz_mfa_axes(res.mfa)
}
\author{
Fabian Mundt \email{f.mundt@inventionate.de}

Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
\references{
http://www.sthda.com
}

