% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgrkPower.R
\name{lgrkPower}
\alias{lgrkPower}
\title{Unstratified (ordinary) logrank power}
\usage{
lgrkPower(hr, nevent, alpha = 0.05, rprob = 0.5)
}
\arguments{
\item{hr}{hazard ratio}

\item{nevent}{expected number of events}

\item{alpha}{two-sided significance level}

\item{rprob}{randomization probability}
}
\value{
\item{power }{logrank power}
}
\description{
Computes the power for the unstratified (ordinary) logrank statistic
for two group comparison.
}
\details{
Uses the formula at the bottom of p.317 from Schoenfeld (Biometrika, 1981)
where the beta should be 1 - beta.
}
\examples{
 hr <- 0.5
 nevent <- 98
 lgrkPower(hr, nevent, alpha = 0.05,  rprob = 0.5)
 # $power
 # [1] 0.9293463

}
\references{
Schoenfeld, D. The asymptotic properties of nonparametric tests for comparing
  survival distributions. Biometrika. 1981; 68: 316-319.
}
\author{
Eric Leifer, James Troendle
}
