% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPermutationVariableImportance.R
\name{.plot_permutation_variable_importance}
\alias{.plot_permutation_variable_importance}
\title{Internal plotting function for permutation variable importance plots}
\usage{
.plot_permutation_variable_importance(
  x,
  color_by,
  facet_by,
  facet_wrap_cols,
  ggtheme,
  discrete_palette,
  x_label,
  y_label,
  legend_label,
  plot_title,
  plot_sub_title,
  caption,
  conf_int_style,
  conf_int_alpha,
  x_range,
  x_breaks
)
}
\arguments{
\item{color_by}{(\emph{optional}) Variables used to determine fill colour of plot
objects. The variables cannot overlap with those provided to the \code{split_by}
argument, but may overlap with other arguments. See details for available
variables.}

\item{facet_by}{(\emph{optional}) Variables used to determine how and if facets of
each figure appear. In case the \code{facet_wrap_cols} argument is \code{NULL}, the
first variable is used to define columns, and the remaing variables are
used to define rows of facets. The variables cannot overlap with those
provided to the \code{split_by} argument, but may overlap with other arguments.
See details for available variables.}

\item{facet_wrap_cols}{(\emph{optional}) Number of columns to generate when facet
wrapping. If NULL, a facet grid is produced instead.}

\item{ggtheme}{(\emph{optional}) \code{ggplot} theme to use for plotting.}

\item{discrete_palette}{(\emph{optional}) Palette used to fill the bars in case a
non-singular variable was provided to the \code{color_by} argument.}

\item{x_label}{(\emph{optional}) Label to provide to the x-axis. If NULL, no label
is shown.}

\item{y_label}{(\emph{optional}) Label to provide to the y-axis. If NULL, no label
is shown.}

\item{legend_label}{(\emph{optional}) Label to provide to the legend. If NULL, the
legend will not have a name.}

\item{plot_title}{(\emph{optional}) Label to provide as figure title. If NULL, no
title is shown.}

\item{plot_sub_title}{(\emph{optional}) Label to provide as figure subtitle. If
NULL, no subtitle is shown.}

\item{caption}{(\emph{optional}) Label to provide as figure caption. If NULL, no
caption is shown.}

\item{conf_int_style}{(\emph{optional}) Confidence interval style. See details for
allowed styles.}

\item{conf_int_alpha}{(\emph{optional}) Alpha value to determine transparency of
confidence intervals or, alternatively, other plot elements with which the
confidence interval overlaps. Only values between 0.0 (fully transparent)
and 1.0 (fully opaque) are allowed.}

\item{x_range}{(\emph{optional}) Value range for the x-axis.}

\item{x_breaks}{(\emph{optional}) Break points on the x-axis of the plot.}
}
\value{
ggplot plot object.
}
\description{
Internal plotting function for permutation variable importance plots
}
\keyword{internal}
