% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationUnivariateAnalysis.R
\name{extract_univariate_analysis}
\alias{extract_univariate_analysis}
\title{Internal function to extract data from a univariate analysis.}
\usage{
extract_univariate_analysis(
  object,
  data,
  cl = NULL,
  icc_type = waiver(),
  feature_similarity = NULL,
  feature_cluster_method = waiver(),
  feature_cluster_cut_method = waiver(),
  feature_linkage_method = waiver(),
  feature_similarity_threshold = waiver(),
  feature_similarity_metric = waiver(),
  message_indent = 0L,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarEnsemble} object, which is an ensemble of one or more
\code{familiarModel} objects.}

\item{data}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}

\item{cl}{Cluster created using the \code{parallel} package. This cluster is then
used to speed up computation through parallellisation.}

\item{icc_type}{String indicating the type of intraclass correlation
coefficient (\code{1}, \code{2} or \code{3}) that should be used to compute robustness for
features in repeated measurements during the evaluation of univariate
importance. These types correspond to the types in Shrout and Fleiss (1979).
If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_cluster_method}{The method used to perform clustering. These are
the same methods as for the \code{cluster_method} configuration parameter:
\code{none}, \code{hclust}, \code{agnes}, \code{diana} and \code{pam}.

\code{none} cannot be used when extracting data regarding mutual correlation or
feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_cluster_cut_method}{The method used to divide features into
separate clusters. The available methods are the same as for the
\code{cluster_cut_method} configuration parameter: \code{silhouette}, \code{fixed_cut} and
\code{dynamic_cut}.

\code{silhouette} is available for all cluster methods, but \code{fixed_cut} only
applies to methods that create hierarchical trees (\code{hclust}, \code{agnes} and
\code{diana}). \code{dynamic_cut} requires the \code{dynamicTreeCut} package and can only
be used with \code{agnes} and \code{hclust}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_linkage_method}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_similarity_threshold}{The threshold level for pair-wise
similarity that is required to form feature clusters with the \code{fixed_cut}
method.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{feature_similarity_metric}{Metric to determine pairwise similarity
between features. Similarity is computed in the same manner as for
clustering, and \code{feature_similarity_metric} therefore has the same options
as \code{cluster_similarity_metric}: \code{mcfadden_r2}, \code{cox_snell_r2},
\code{nagelkerke_r2}, \code{spearman}, \code{kendall} and \code{pearson}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{message_indent}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}

\item{verbose}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}

\item{...}{Unused arguments.}
}
\value{
A list with a data.table containing information concerning the
univariate analysis of important features.
}
\description{
Computes and extracts univariate analysis for the features used
in a \code{familiarEnsemble} object. This assessment includes the computation of
p and q-values, as well as robustness (in case of repeated measurements).
}
\keyword{internal}
