% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fancycut.R
\name{fancycut}
\alias{fancycut}
\title{Like \code{cut}, turn a vector of numbers into a factor}
\usage{
fancycut(x, intervals, buckets, na.bucket = NA, unmatched.bucket = NA,
  out.as.factor = TRUE)
}
\arguments{
\item{x}{a numeric vector}

\item{intervals}{a character vector of intervals}

\item{buckets}{a character vector of levels for the new factor
these have a 1-1 correspondence with \code{intervals}}

\item{na.bucket}{what level should NA values be given?}

\item{unmatched.bucket}{what level should numbers not covered by an interval be given?}

\item{out.as.factor}{default is TRUE
  Should the resulting vector be a factor?
  If FALSE will return a character vector.}
}
\description{
Like \code{cut}, turn a vector of numbers into a factor
}
\examples{
x <- round(runif(1000, 0, 10))
intervals <- c('(0,2]','(2,5)','[5,10]')
buckets <- c('Small','Medium','Large')
fc <- fancycut(x, intervals, buckets)
df <- data.frame(x, fc)
}

