% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unhandled.R
\name{unhandled_ctl}
\alias{unhandled_ctl}
\title{Identify Unhandled ANSI Control Sequences}
\usage{
unhandled_ctl(x)
}
\arguments{
\item{x}{character vector}
}
\value{
data frame with as many rows as there are unhandled escape
sequences and columns containing useful information for debugging the
problem.  See details.
}
\description{
Will return position and types of unhandled \emph{Control Sequences} in a
character vector.  Unhandled sequences may cause \code{fansi} to interpret strings
in a way different to your display.  See \link{fansi} for details.
}
\details{
This is a debugging function that is not optimized for speed.

The return value is a data frame with five columns:
\itemize{
\item index: integer the index in \code{x} with the unhandled sequence
\item start: integer the start position of the sequence (in characters)
\item stop: integer the end of the sequence (in characters), but note that if
there are multiple ESC sequences abutting each other they will all be
treated as one, even if some of those sequences are valid.
\item error: the reason why the sequence was not handled:
\itemize{
\item exceed-term-cap: contains color codes not supported by the terminal
(see \link{term_cap_test}).
\item special: SGR substring contains uncommon characters in ":<=>".
\item unknown: SGR substring with a value that does not correspond to a known
SGR code.
\item non-SGR: a non-SGR CSI sequence.
\item non-CSI: a non-CSI escape sequence, i.e. one where the ESC is
followed by something other than "[".  Since we assume all non-CSI
sequences are only 2 characters long include the ESC, this type of
sequence is the most likely to cause problems as many are not actually
two characters long.
\item malformed-CSI: a malformed CSI sequence.
\item malformed-ESC: a malformed ESC sequence (i.e. one not ending in
0x40-0x7e).
\item C0: a "C0" control character (e.g. tab, bell, etc.).
}
\item translated: whether the string was translated to UTF-8, might be helpful in
odd cases were character offsets change depending on encoding.  You should
only worry about this if you cannot tie out the \code{start}/\code{stop} values to
the escape sequence shown.
\item esc: character the unhandled escape sequence
}
}
\note{
Non-ASCII strings are converted to UTF-8 encoding.
}
\examples{
string <- c(
  "\\033[41mhello world\\033[m", "foo\\033[22>m", "\\033[999mbar",
  "baz \\033[31#3m", "a\\033[31k", "hello\\033m world"
)
unhandled_ctl(string)
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
