/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.Crop;
import jfm.model.CroppingComponent;
import jfm.model.ELSOption;
import jfm.model.ELSOptionComponent;
import jfm.model.Farm;
import jfm.model.Operation;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubblesComponent
extends ELSOptionComponent {
    private int startPeriod;
    private int endPeriod;
    private double subsidy;
    public static Types.ELSCode elscode = Types.ELSCode.EF6;
    private static Set<Types.OperationType> harvestOps = new HashSet<Types.OperationType>();
    private static Set<Types.OperationType> ploughOps = new HashSet<Types.OperationType>();

    public StubblesComponent(int endP, double cashSubsidy_) {
        super(ModelComponent.MCType.STUBBLES);
        this.requireObjective(Types.ObjectiveType.WINTERSTUBBLE);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.addConstraintBuilder(new WinterStubbleEqualityConstraint());
        this.endPeriod = endP;
        this.subsidy = cashSubsidy_;
        this.options.put(elscode, new ELSOption(elscode, 0.0, StubblesComponent.elscode.defaultPoints));
    }

    @Override
    public StubblesComponent copy() {
        return new StubblesComponent(this.endPeriod, this.subsidy);
    }

    public void setSubsidy(double subs) {
        this.subsidy = subs;
        this.requireMatrixRebuild();
    }

    @Override
    public void setFormulaVariables() {
    }

    @Override
    protected void initializeStructure() {
        Farm farm = this.getParent();
        this.startPeriod = farm.numPeriods - 1;
        CroppingComponent cropping = farm.cropping;
        MatrixVariable newVariable = new MatrixVariable(this.subsidy, 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
        newVariable.setTag("Total Winter Stubble");
        this.matrix.addVariable(newVariable);
        ((ELSOption)this.options.get((Object)elscode)).registerVariable(newVariable, 0);
        ((ELSOption)this.options.get((Object)elscode)).registerParent(this);
        for (Types.CropType ct : cropping.baseCropTypes()) {
            if (ct == Types.CropType.SETASIDE) continue;
            for (Crop.CropCopy cp : cropping.getCrop(ct).getYearCopies()) {
                Operation harvest = StubblesComponent.getMatchingOperation(harvestOps, cp);
                Operation plough = StubblesComponent.getMatchingOperation(ploughOps, cp);
                Set<Integer> allowedPeriodsHarv = harvest.unfoldedAllowedSet();
                for (int p = farm.numPeriods; p <= this.startPeriod + farm.numPeriods; ++p) {
                    if (!allowedPeriodsHarv.contains(p)) continue;
                    harvest.setCoefficientAndRegisterObjective(Types.ObjectiveType.WINTERSTUBBLE, 1.0, p);
                    Set<Integer> allowedPeriodsPlgh = plough.unfoldedAllowedSet();
                    for (int pp = 0; pp <= farm.numPeriods + this.endPeriod; ++pp) {
                        if (!allowedPeriodsPlgh.contains(pp)) continue;
                        plough.setCoefficientAndRegisterObjective(Types.ObjectiveType.WINTERSTUBBLE, -1.0, pp);
                    }
                }
            }
        }
    }

    public static Operation getMatchingOperation(Set<Types.OperationType> opList, Crop.CropCopy cp) {
        List<Operation> ops = cp.operations();
        for (Operation op : ops) {
            if (!opList.contains((Object)op.type)) continue;
            return op;
        }
        throw new Error("No matching operation for crop " + (Object)((Object)cp.type()) + " in list " + opList);
    }

    public static double stubbleAreaForRotation(Types.CropType from, Types.CropType to, int endP, Farm farm) {
        boolean firstYr = true;
        if (from == to) {
            firstYr = false;
        }
        HashMap<Integer, Double> pltime = StubblesComponent.getEndStubbleTimingForCrop(to, firstYr, endP, farm);
        double areaS = 0.0;
        for (Double d : pltime.values()) {
            areaS += d.doubleValue();
        }
        return areaS;
    }

    public static HashMap<Integer, Double> getHarvestTimingForCrop(Types.CropType from, boolean firstYr, Farm farm) {
        CroppingComponent cropping = farm.cropping;
        int startPeriod = farm.numPeriods - 1;
        HashMap<Integer, Double> ha = new HashMap<Integer, Double>();
        int yr = 0;
        for (Crop.CropCopy cp : cropping.getCrop(from).getYearCopies()) {
            if (!(firstYr && yr > 0 || !firstYr && yr == 0)) {
                Operation harvest = StubblesComponent.getMatchingOperation(harvestOps, cp);
                Set<Integer> allowedPeriodsHarv = harvest.unfoldedAllowedSet();
                for (int p = farm.numPeriods; p <= startPeriod + farm.numPeriods; ++p) {
                    if (!allowedPeriodsHarv.contains(p)) continue;
                    double a = 0.0;
                    if (ha.containsKey(p)) {
                        a = ha.get(p);
                    }
                    ha.put(p, harvest.solvedArea(p) + a);
                }
            }
            ++yr;
        }
        return ha;
    }

    public static HashMap<Integer, Double> getEndStubbleTimingForCrop(Types.CropType to, boolean firstYr, int endP, Farm farm) {
        CroppingComponent cropping = farm.cropping;
        HashMap<Integer, Double> pl = new HashMap<Integer, Double>();
        int yr = 0;
        for (Crop.CropCopy cp : cropping.getCrop(to).getYearCopies()) {
            if (!(firstYr && yr > 0 || !firstYr && yr == 0)) {
                Operation plough = StubblesComponent.getMatchingOperation(ploughOps, cp);
                Set<Integer> allowedPeriodsPlgh = plough.unfoldedAllowedSet();
                for (int pp = farm.numPeriods + endP; pp < farm.numPeriods * Farm.maxYears; ++pp) {
                    if (!allowedPeriodsPlgh.contains(pp)) continue;
                    double a = 0.0;
                    if (pl.containsKey(pp)) {
                        a = pl.get(pp);
                    }
                    pl.put(pp, plough.solvedArea(pp) + a);
                }
            }
            ++yr;
        }
        return pl;
    }

    @Override
    protected String name() {
        return "Stubbles";
    }

    @Override
    protected void updateStructure() {
        this.structureUpdateDone();
    }

    static {
        harvestOps.add(Types.OperationType.COMBINE);
        harvestOps.add(Types.OperationType.HARVEST);
        ploughOps.add(Types.OperationType.PLOUGH);
        ploughOps.add(Types.OperationType.BROADCAST);
    }

    public final class WinterStubbleEqualityConstraint
    extends ConstraintBuilder {
        public WinterStubbleEqualityConstraint() {
            super(ConstraintBuilder.CBType.WSEQUAL, ModelComponent.MCType.STUBBLES);
        }

        protected void build() {
            Farm farm = StubblesComponent.this.getParent();
            int row = StubblesComponent.this.matrix.numRows();
            CroppingComponent cropping = farm.cropping;
            MatrixRow rp = new MatrixRow(0.0, 0.0, LPX.LPX_UP, row, "WSProfit", "WSProfit");
            StubblesComponent.this.matrix.addRow(rp);
            ++row;
            rp.addElement(new MatrixElement(((ELSOption)StubblesComponent.this.options.get((Object)elscode)).getDependentColumn(0), 1.0));
            for (Types.CropType ct : cropping.baseCropTypes()) {
                if (ct == Types.CropType.SETASIDE) continue;
                for (Crop.CropCopy cp : cropping.getCrop(ct).getYearCopies()) {
                    Operation harvest = StubblesComponent.getMatchingOperation(harvestOps, cp);
                    Operation plough = StubblesComponent.getMatchingOperation(ploughOps, cp);
                    Set<Integer> allowedPeriodsHarv = harvest.unfoldedAllowedSet();
                    for (int p = farm.numPeriods; p <= StubblesComponent.this.startPeriod + farm.numPeriods; ++p) {
                        if (!allowedPeriodsHarv.contains(p)) continue;
                        rp.addElement(new MatrixElement(harvest.getDependentColumn(p), -1.0));
                        Set<Integer> allowedPeriodsPlgh = plough.unfoldedAllowedSet();
                        for (int pp = 0; pp <= farm.numPeriods + StubblesComponent.this.endPeriod; ++pp) {
                            if (!allowedPeriodsPlgh.contains(pp)) continue;
                            rp.addElement(new MatrixElement(plough.getDependentColumn(pp), 1.0));
                        }
                    }
                }
            }
        }
    }
}

