/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jfm.lp.ModelComponent;
import jfm.lp.Objective;
import jfm.model.Crop;
import jfm.model.ELSOptionsComponent;
import jfm.model.Farm;
import jfm.model.FreeTimeComponent;
import jfm.model.Types;
import jfm.utils.MathPrint;

public final class Output {
    public static String oneLineSummary(Farm farm) {
        StringBuffer buff = new StringBuffer();
        HashMap<Double, Types.CropType> cropAreas = new HashMap<Double, Types.CropType>();
        for (Types.CropType ct : farm.cropping.baseCropTypes()) {
            cropAreas.put(farm.cropping.getCrop(ct).getSolvedArea(), ct);
        }
        buff.append("Total: " + MathPrint.f2.format(farm.landUse.getArea()) + " ");
        ArrayList areas = new ArrayList(cropAreas.keySet());
        Collections.sort(areas);
        int numDisplay = Math.min(areas.size(), 6);
        for (int i = 0; i < numDisplay; ++i) {
            Double a = (Double)areas.get(areas.size() - 1 - i);
            buff.append(((Types.CropType)((Object)cropAreas.get((Object)a))).shortName + ": " + MathPrint.f2.format(a) + " ");
        }
        return buff.toString();
    }

    public static String formulaChecks(Farm farm) {
        StringBuffer buff = new StringBuffer();
        for (Crop cp : farm.cropping.getCrops().values()) {
            buff.append((Object)((Object)cp.type) + "\n");
            buff.append(cp.printFormulaCheck(farm.location()));
        }
        return buff.toString();
    }

    public static String profitSummary(Farm farm, boolean useMarginals) {
        StringBuffer buff = new StringBuffer();
        double totalProfit = 0.0;
        for (Types.CropType ct : farm.cropping.baseCropTypes()) {
            for (Crop.CropCopy cc : farm.cropping.getCrop(ct).getYearCopies()) {
                if (!(cc.getSolvedArea() > 0.0)) continue;
                Map<String, Double> profits = cc.getProfitSummary(useMarginals);
                buff.append(cc.name() + " " + profits.get("Total") + " " + profits.get("Gross") + " " + profits.get("OpPenalty") + " " + profits.get("OpFuel"));
                buff.append("\n");
                totalProfit += profits.get("Total").doubleValue();
            }
        }
        buff.append("Total: " + totalProfit);
        return buff.toString();
    }

    public static String detailedObjectiveSummary(Farm farm) {
        StringBuffer buff = new StringBuffer();
        int columnWidth = 15;
        Map<Types.ObjectiveType, Objective> objs = farm.getObjectives();
        for (Types.ObjectiveType obj : objs.keySet()) {
            buff.append((Object)((Object)obj) + ":" + MathPrint.f2.format(farm.getValueForObjective(obj)) + " " + MathPrint.f2.format(objs.get((Object)obj).scaleFactor()) + " " + MathPrint.f2.format(objs.get((Object)obj).scaleFactor() * farm.getValueForObjective(obj)) + "\n");
        }
        for (Types.CropType ct : farm.cropping.baseCropTypes()) {
            for (Crop.CropCopy cc : farm.cropping.getCrop(ct).getYearCopies()) {
                if (!(cc.getSolvedArea() > 0.0)) continue;
                buff.append(cc.getDetailedProfitBreakdown(columnWidth));
            }
        }
        return buff.toString();
    }

    public static String workloadSummary(Farm farm) {
        StringBuffer buff = new StringBuffer();
        Map<Integer, LinkedHashMap<Object, Double>> workLoad = farm.workers.getWorkload();
        if (farm.objectives().containsKey((Object)Types.ObjectiveType.FREETIME)) {
            FreeTimeComponent ftc = (FreeTimeComponent)farm.getModelComponent(ModelComponent.MCType.FREETIME);
            Map<Integer, Double> ft = ftc.getSolvedFreeTime();
            for (int p = 0; p < workLoad.size(); ++p) {
                Map work = workLoad.get(p);
                work.put(Types.ObjectiveType.FREETIME, ft.get(p));
            }
        }
        ArrayList<Object> masterKeys = new ArrayList<Object>(workLoad.get(0).keySet());
        for (Object key : masterKeys) {
            buff.append(key + ",");
        }
        buff.deleteCharAt(buff.length() - 1);
        buff.append("\n");
        for (int p = 0; p < farm.numPeriods; ++p) {
            for (Object key : masterKeys) {
                buff.append(MathPrint.f2.format(workLoad.get(p).get(key)) + ",");
            }
            buff.deleteCharAt(buff.length() - 1);
            buff.append("\n");
        }
        return buff.toString();
    }

    public static String solution(Farm farm, boolean detailed) {
        StringBuffer buff = new StringBuffer();
        for (Objective op : farm.objectives().values()) {
            buff.append((Object)((Object)op.type) + ": " + MathPrint.df2.format(farm.getValueForObjective(op.type)) + "\n");
        }
        if (farm.getComponents().keySet().contains((Object)ModelComponent.MCType.HEDGEROWS)) {
            buff.append("\n-- Hedge Length: " + farm.getValueForObjective(Types.ObjectiveType.HEDGEROWS) + "\n");
        }
        if (farm.getComponents().keySet().contains((Object)ModelComponent.MCType.ELSOPTIONS)) {
            ELSOptionsComponent comp = (ELSOptionsComponent)farm.getModelComponent(ModelComponent.MCType.ELSOPTIONS);
            buff.append("\n-- ELS Options Summary --\n" + comp.printSolution());
        }
        buff.append("\n" + farm.cropping.printSolution(farm, detailed) + " \n");
        buff.append(farm.rotations.printSolution() + "\n ");
        buff.append(farm.workers.printSolution(farm));
        buff.append("\n" + farm.workers.printFixedCosts(farm) + "\n");
        return buff.toString();
    }

    public static String csvWorkPlan(Farm farm) {
        return farm.cropping.printCSVWorkPlan();
    }
}

