% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_seasons.R
\name{add_seasons}
\alias{add_seasons}
\title{Add a column of seasons}
\usage{
add_seasons(
  data,
  dates = Date,
  station_number,
  water_year_start = 1,
  seasons_length
)
}
\arguments{
\item{data}{A data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank if using \code{station_number} argument.}

\item{dates}{Column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not '
Date' (default). Leave blank if using \code{station_number} argument.}

\item{station_number}{A character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{water_year_start}{Numeric value indicating the month of the start of the water year for analysis. Default \code{1}.}

\item{seasons_length}{Numeric value indicating the desired length of seasons in months, divisible into 12. Required.}
}
\value{
A tibble data frame of the source data with additional column:
  \item{Season}{season identifier labelled by the start and end month of the season}
}
\description{
Adds a column of seasons identifiers to a data frame with a column of dates called 'Date'. The length of seasons,
   in months, is provided using the seasons_length argument. As seasons are grouped by months the length of the seasons must be
   divisible into 12 with one of the following season lengths: 1, 2, 3, 4, 6, or 12 months. The start of the first season 
   coincides with the start month of each year; 'Jan-Jun' for 6-month seasons starting with calendar years or 'Dec-Feb' for 3-month
   seasons starting with water year starting in December.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Add a column with four annual seasons starting in January
add_seasons(station_number = "08NM116",
            seasons_length = 4)

# Add a column with two annual seasons (of 6 months length) starting in October
add_seasons(station_number = "08NM116", 
            water_year_start = 10,
            seasons_length = 6)
            
}
}
