% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_flow_data.R
\name{write_flow_data}
\alias{write_flow_data}
\title{Write a streamflow dataset as a .xlsx, .xls, or .csv file}
\usage{
write_flow_data(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  water_year_start = 1,
  start_year,
  end_year,
  start_date,
  end_date,
  file_name,
  fill_missing = FALSE,
  digits
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year of data to write. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year of data to write. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{start_date}{Date (YYYY-MM-DD) of first date of data to write. Leave blank or set well before start date (i.e.
\code{1800-01-01}) if all dates required.}

\item{end_date}{Date (YYYY-MM-DD) of last date of data to write. Leave blank or set well after end date (i.e.
\code{2100-12-31}) if all dates required.}

\item{file_name}{Character string naming the output file. If none provided, a default file name (with .xlsx) is provided (see 
"Successfully created" message when using function for file name).}

\item{fill_missing}{Logical value indicating whether to fill dates with missing flow data with NA. Default \code{FALSE}.}

\item{digits}{Integer indicating the number of decimal places or significant digits used to round flow values. Use follows 
that of base::round() digits argument.}
}
\description{
Write a daily streamflow data set to a directory. Can fill missing dates or filter data by years or dates before 
   writing using given arguments. List data frame or HYDAT station number to write its entirety. Can write as .xls, .xlsx, or .csv 
   file types. Writing as Excel file type uses the \code{writexl} package.
}
\examples{
\dontrun{

# Working examples:

# Write data from a data frame
flow_data <- tidyhydat::hy_daily_flows(station_number = "08NM116")
write_flow_data(data = flow_data, 
                file_name = "Mission_Creek_daily_flows.xlsx")

# Write data directly from HYDAT
write_flow_data(station_number = "08NM116", 
                file_name = "Mission_Creek_daily_flows.xlsx")

# Write data directly from HYDAT and fill missing dates with NA
write_flow_data(station_number = "08NM116", 
                file_name = "Mission_Creek_daily_flows.xlsx",
                fill_missing = TRUE)

}
}
