% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{NCAAbb}
\alias{NCAAbb}
\title{NCAA Division I Basketball Results}
\format{
Nine variables describing NCAA Division I basketball games.
\itemize{ 
\item{date}{ date on which game was played}
\item{away}{ visiting team} 
\item{ascore}{ visiting team's score} 
\item{home}{ home team} 
\item{hscore}{ home team's score} 
\item{notes}{ code indicting games played at neutral sites (n or N) or 
in tournaments (T)} 
\item{location}{ where game was played}
\item{season}{ a character indicating which season the game belonged to}
\item{postseason}{ a logical indicating whether the game is a postseason game}
}
}
\source{
\url{https://kenpom.com}
}
\description{
Results of NCAA basketball games
}
\examples{

data(NCAAbb)
# select one year and add some additional variables to the data frame
NCAA2010 <-
  NCAAbb \%>\% 
  filter(season == "2009-10") \%>\%
  mutate(
    dscore = hscore - ascore,
    homeTeamWon = dscore > 0,
    numHomeTeamWon <- -1 + 2 * as.numeric(homeTeamWon),
    winner = ifelse(homeTeamWon, home, away),
    loser  = ifelse(homeTeamWon, away, home),
    wscore = ifelse(homeTeamWon, hscore, ascore),
    lscore = ifelse(homeTeamWon, ascore, hscore)
  )
NCAA2010 \%>\% select(date, winner, loser, wscore, lscore, dscore, homeTeamWon) \%>\% head()
}
\keyword{datasets}
