% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directed_erdos_renyi.R
\name{directed_erdos_renyi}
\alias{directed_erdos_renyi}
\title{Create an directed erdos renyi object}
\usage{
directed_erdos_renyi(n, ..., p = NULL)
}
\arguments{
\item{n}{Number of nodes in graph.}

\item{...}{
  Arguments passed on to \code{\link[=directed_factor_model]{directed_factor_model}}
  \describe{
    \item{\code{expected_in_degree}}{If specified, the desired expected in degree
of the graph. Specifying \code{expected_in_degree} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Specify only one of
\code{expected_in_degree}, \code{expected_out_degree}, and \code{expected_density}.}
    \item{\code{expected_out_degree}}{If specified, the desired expected out degree
of the graph. Specifying \code{expected_out_degree} simply rescales \code{S}
to achieve this. Defaults to \code{NULL}. Specify only one of
\code{expected_in_degree}, \code{expected_out_degree}, and \code{expected_density}.}
  }}

\item{p}{Probability of an edge between any two nodes. You must specify
either \code{p}, \code{expected_in_degree}, or \code{expected_out_degree}.}
}
\value{
Never returns Poisson edges.
}
\description{
Create an directed erdos renyi object
}
\examples{

set.seed(87)

er <- directed_erdos_renyi(n = 10, p = 0.1)
er

big_er <- directed_erdos_renyi(n = 10^6, expected_in_degree = 5)
big_er

A <- sample_sparse(er)
A

}
\seealso{
Other bernoulli graphs: 
\code{\link{erdos_renyi}()}

Other erdos renyi: 
\code{\link{erdos_renyi}()}
}
\concept{bernoulli graphs}
\concept{directed graphs}
\concept{erdos renyi}
