% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uv_cox.R
\name{uv_cox}
\alias{uv_cox}
\title{Looping for Univariable Cox Regression}
\usage{
uv_cox(data, time, event, variable, adjust, round = 3,
  p_threshold = 0.05, order_by.hr = TRUE)
}
\arguments{
\item{data}{data}

\item{time}{time variable}

\item{event}{event variable}

\item{variable}{variable names for univariable cox regression. If missing, it will be column names of data except y and adjust}

\item{adjust}{adjust variable names for univariable cox regression}

\item{round}{digital round, 3 is defaulted}

\item{p_threshold}{threshold for p value to show star. 0.05 is defaulted}

\item{order_by.hr}{logical. TRUE means order in or by decreasing. FLASE is defaulted}
}
\value{
univariable cox regression results
}
\description{
Looping for Univariable Cox Regression
}
\examples{
uv_cox(data = mtcars,
    time = 'qsec',event = 'vs')
}
