% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crisk.R
\name{Crisk}
\alias{Crisk}
\title{Create a Competing Risk Object}
\usage{
Crisk(ftime, fstatus, cencode = 0, failcode = 1, silent = TRUE)
}
\arguments{
\item{ftime}{A vector of event/censoring times.}

\item{fstatus}{A vector with unique code for each event type and a separate code for censored observations.}

\item{cencode}{Integer: code of \code{fstatus} that denotes censored observations (default is 0)}

\item{failcode}{Integer: code of \code{fstatus} that event type of interest (default is 1)}

\item{silent}{Logical: print information about coding.}
}
\value{
Returns an object, used as a response variable, of class \code{Crisk}.
\item{time}{vector of observed event times}
\item{status}{vector of event indicators. 0 = censored, 1 = event of interest, 2 = competing risks}
}
\description{
Create a competing risk object, used as a response variable in the model formula for \code{fastCrr} and \code{fastCrrp}.
Adapted from the \code{Surv} object.
}
\examples{
library(fastcmprsk)

set.seed(10)
ftime <- rexp(200)
fstatus <- sample(0:2, 200, replace = TRUE)
obj <- Crisk(ftime, fstatus, silent = FALSE)
}
\references{
Fine J. and Gray R. (1999) A proportional hazards model for the subdistribution of a competing risk.  \emph{JASA} 94:496-509.
}
\seealso{
Surv
}
